untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ/9ZByBSf/YnpAx05RoMZegxjmiw3ozzj91vJbpq/ngp+Dftj/BQiVpa46OAhM+NeFyR1qop2/5ykksQq4shNQ0=
OpenBSD 6.0 errata 043, September 27, 2017:

Out of bounds TCB settings may result in a kernel panic.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 043_tcb.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/arch/amd64/amd64/sys_machdep.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/sys_machdep.c,v
--- sys/arch/amd64/amd64/sys_machdep.c	18 May 2015 19:59:27 -0000	1.16
+++ sys/arch/amd64/amd64/sys_machdep.c	27 Sep 2017 06:32:39 -0000
@@ -111,6 +111,8 @@ amd64_set_fsbase(struct proc *p, void *a
 	if ((error = copyin(args, &base, sizeof(base))) != 0)
 		return (error);
 
+	if (TCB_INVALID(base))
+		return EINVAL;
 	tcb_set(p, base);
 	return 0;
 }
Index: sys/arch/amd64/include/tcb.h
===================================================================
RCS file: /cvs/src/sys/arch/amd64/include/tcb.h,v
--- sys/arch/amd64/include/tcb.h	18 May 2015 19:59:27 -0000	1.3
+++ sys/arch/amd64/include/tcb.h	27 Sep 2017 06:33:15 -0000
@@ -27,6 +27,9 @@ void	tcb_set(struct proc *_p, void *_new
 #define TCB_GET(p)		tcb_get(p)
 #define TCB_SET(p, addr)	tcb_set(p, addr)
 
+/* address must be in canonical form; requiring lower-half is okay */
+#define TCB_INVALID(addr)	((u_long)(addr) > 0x0000ffffffffffff)
+
 #else /* _KERNEL */
 
 #include <stddef.h>		/* for offsetof */
Index: sys/kern/kern_fork.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_fork.c,v
--- sys/kern/kern_fork.c	25 Apr 2016 20:18:31 -0000	1.187
+++ sys/kern/kern_fork.c	27 Sep 2017 06:32:07 -0000
@@ -129,6 +129,10 @@ sys___tfork(struct proc *p, void *v, reg
 	if (KTRPOINT(p, KTR_STRUCT))
 		ktrstruct(p, "tfork", &param, sizeof(param));
 #endif
+#ifdef TCB_INVALID
+	if (TCB_INVALID(param.tf_tcb))
+		return EINVAL;
+#endif /* TCB_INVALID */
 
 	flags = FORK_TFORK | FORK_THREAD | FORK_SIGHAND | FORK_SHAREVM
 	    | FORK_SHAREFILES;
Index: sys/kern/kern_prot.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_prot.c,v
--- sys/kern/kern_prot.c	30 Mar 2016 07:49:11 -0000	1.65
+++ sys/kern/kern_prot.c	27 Sep 2017 06:32:01 -0000
@@ -1094,6 +1094,10 @@ sys___set_tcb(struct proc *p, void *v, r
 		syscallarg(void *) tcb;
 	} */ *uap = v;
 
+#ifdef TCB_INVALID
+	if (TCB_INVALID(SCARG(uap, tcb)))
+		return EINVAL;
+#endif /* TCB_INVALID */
 	TCB_SET(p, SCARG(uap, tcb));
 	return (0);
 }
