untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ8uLlE/2x21afWh28cxDmpSO7LhyEJdxRTUJBscHYM5sMJ3952+Gs9Mr6g3EE0CkKe0aFd91GExK6k8IzbUljww=

OpenBSD 6.0 errata 01, Aug 02, 2016:

Missing overflow checks in uvm may result in panics.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 001_uvmisavail.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/uvm/uvm_map.c
===================================================================
RCS file: /cvs/src/sys/uvm/uvm_map.c,v
retrieving revision 1.217
diff -u -p -r1.217 uvm_map.c
--- sys/uvm/uvm_map.c	17 Jun 2016 10:48:25 -0000	1.217
+++ sys/uvm/uvm_map.c	1 Aug 2016 19:22:10 -0000
@@ -771,6 +771,9 @@ uvm_map_isavail(struct vm_map *map, stru
 	struct uvm_map_addr *atree;
 	struct vm_map_entry *i, *i_end;
 
+	if (addr + sz < addr)
+		return 0;
+
 	/*
 	 * Kernel memory above uvm_maxkaddr is considered unavailable.
 	 */
@@ -1033,6 +1036,12 @@ uvm_mapanon(struct vm_map *map, vaddr_t 
 			goto unlock;
 	}
 
+	/* Check if selected address doesn't cause overflow. */
+	if (*addr + sz < *addr) {
+		error = ENOMEM;
+		goto unlock;
+	}
+
 	/* If we only want a query, return now. */
 	if (flags & UVM_FLAG_QUERY) {
 		error = 0;
@@ -1274,6 +1283,12 @@ uvm_map(struct vm_map *map, vaddr_t *add
 
 		if (error != 0)
 			goto unlock;
+	}
+
+	/* Check if selected address doesn't cause overflow. */
+	if (*addr + sz < *addr) {
+		error = ENOMEM;
+		goto unlock;
 	}
 
 	KASSERT((map->flags & VM_MAP_ISVMSPACE) == VM_MAP_ISVMSPACE ||
