/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.similarities;

import org.apache.lucene.search.similarities.Distribution;
import org.apache.lucene.search.similarities.DistributionLL;
import org.apache.lucene.search.similarities.DistributionSPL;
import org.apache.lucene.search.similarities.IBSimilarity;
import org.apache.lucene.search.similarities.Lambda;
import org.apache.lucene.search.similarities.LambdaDF;
import org.apache.lucene.search.similarities.LambdaTTF;
import org.apache.lucene.search.similarities.Normalization;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.search.similarities.DFRSimilarityFactory;

public class IBSimilarityFactory
extends SimilarityFactory {
    private boolean discountOverlaps;
    private Distribution distribution;
    private Lambda lambda;
    private Normalization normalization;

    @Override
    public void init(SolrParams params) {
        super.init(params);
        this.discountOverlaps = params.getBool("discountOverlaps", true);
        this.distribution = this.parseDistribution(params.get("distribution"));
        this.lambda = this.parseLambda(params.get("lambda"));
        this.normalization = DFRSimilarityFactory.parseNormalization(params.get("normalization"), params.get("c"), params.get("mu"), params.get("z"));
    }

    private Distribution parseDistribution(String expr) {
        if ("LL".equals(expr)) {
            return new DistributionLL();
        }
        if ("SPL".equals(expr)) {
            return new DistributionSPL();
        }
        throw new RuntimeException("Invalid distribution: " + expr);
    }

    private Lambda parseLambda(String expr) {
        if ("DF".equals(expr)) {
            return new LambdaDF();
        }
        if ("TTF".equals(expr)) {
            return new LambdaTTF();
        }
        throw new RuntimeException("Invalid lambda: " + expr);
    }

    @Override
    public Similarity getSimilarity() {
        IBSimilarity sim = new IBSimilarity(this.distribution, this.lambda, this.normalization);
        sim.setDiscountOverlaps(this.discountOverlaps);
        return sim;
    }
}

