/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.galleon.cli.model.FeatureInfo;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.cli.model.PackageInfo;

public class Group
implements Comparable<Group> {
    private final Set<Group> groups = new TreeSet<Group>();
    private FeatureSpecInfo featureSpec;
    private FeatureInfo feature;
    private PackageInfo pkg;
    private Group previous;
    private final Identity id;

    private Group(Identity id) {
        this.id = id;
    }

    static Group fromIdentity(Identity id) {
        return new Group(id);
    }

    public static Group fromString(String origin, String name) {
        return new Group(Identity.fromString(origin == null ? "" : origin, name));
    }

    public Identity getIdentity() {
        return this.id;
    }

    public void setPrevious(Group previous) {
        this.previous = previous;
    }

    public Group getPrevious() {
        return this.previous;
    }

    public void addGroup(Group fg) {
        this.groups.add(fg);
        fg.setPrevious(this);
    }

    public void setPackage(PackageInfo pkg) {
        this.pkg = pkg;
    }

    public PackageInfo getPackage() {
        return this.pkg;
    }

    public void setFeatureSpec(FeatureSpecInfo f) {
        this.featureSpec = f;
        f.setName(this.getIdentity().getName());
    }

    public void setFeature(FeatureInfo f) {
        this.feature = f;
    }

    public FeatureInfo getFeature() {
        return this.feature;
    }

    public FeatureSpecInfo getSpec() {
        return this.featureSpec;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Group)) {
            return false;
        }
        Group ofg = (Group)other;
        return this.getIdentity().equals(ofg.getIdentity());
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.id);
        return hash;
    }

    @Override
    public int compareTo(Group o) {
        return this.getIdentity().compareTo(o.getIdentity());
    }
}

