/* $MidnightBSD: src/usr.bin/xlint/common/ilp32.h,v 1.2 2007/07/26 19:28:20 laffer1 Exp $ */
/*	$NetBSD: ilp32.h,v 1.1 2002/01/18 20:39:23 thorpej Exp $	*/

/*
 * Copyright (c) 2001 Wasabi Systems, Inc.
 * All rights reserved.
 *
 * Written by Jason R. Thorpe for Wasabi Systems, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed for the NetBSD Project by
 *	Wasabi Systems, Inc.
 * 4. The name of Wasabi Systems, Inc. may not be used to endorse
 *    or promote products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY WASABI SYSTEMS, INC. ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL WASABI SYSTEMS, INC
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Type sizes for IPL32 platforms (int, long, pointer: 32-bit)
 */

#define	CHAR_SIZE	(CHAR_BIT)
#define	SHORT_SIZE	(2 * CHAR_BIT)
#define	INT_SIZE	(4 * CHAR_BIT)
#define	LONG_SIZE	(4 * CHAR_BIT)
#define	QUAD_SIZE	(8 * CHAR_BIT)
#define	PTR_SIZE	(4 * CHAR_BIT)

#define	TARG_INT_MAX	((int32_t) (((uint32_t) -1) >> 1))
#define	TARG_INT_MIN	((-TARG_INT_MAX) - 1)
#define	TARG_UINT_MAX	((uint32_t) -1)

#define	TARG_LONG_MAX	TARG_INT_MAX
#define	TARG_LONG_MIN	TARG_INT_MIN
#define	TARG_ULONG_MAX	TARG_UINT_MAX

#define	TARG_QUAD_MAX	((int64_t) (((uint64_t) -1) >> 1))
#define	TARG_QUAD_MIN	((-TARG_QUAD_MAX) - 1)
#define	TARG_UQUAD_MAX	((uint64_t) -1)
