/*-
 * Copyright (C) 2005 Max Okumoto.
 *	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $MidnightBSD: src/usr.bin/make/proc.h,v 1.2 2008/09/29 20:36:53 laffer1 Exp $
 * $FreeBSD: src/usr.bin/make/proc.h,v 1.1 2005/05/24 15:41:34 harti Exp $
 */

#ifndef proc_h_458845848
#define proc_h_458845848

/**
 * Information used to create a new process.
 */
typedef struct ProcStuff {
	int	in;	/* stdin for new process */
	int	out;	/* stdout for new process */
	int	err;	/* stderr for new process */

	int	merge_errors;	/* true if stderr is redirected to stdin */
	int	pgroup;		/* true if new process a process leader */
	int	searchpath;	/* true if binary should be found via $PATH */

	char	**argv;
	int	argv_free;	/* release argv after use */
	int	errCheck;

	pid_t	child_pid;
} ProcStuff;

void Proc_Exec(const ProcStuff *) __dead2;

#endif /* proc_h_458845848 */
