/*
 * Copyright (C) 2004-2011 Internet Systems Consortium, Inc. ("ISC")
 * Copyright (C) 1998-2003 Internet Software Consortium.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/***************
 ***************
 ***************   THIS FILE IS AUTOMATICALLY GENERATED BY gen.c.
 ***************   DO NOT EDIT!
 ***************
 ***************/

/*! \file */

#ifndef DNS_CODE_H
#define DNS_CODE_H 1

#include <isc/boolean.h>
#include <isc/result.h>

#include <dns/name.h>

#include "rdata/in_1/a_1.c"
#include "rdata/ch_3/a_1.c"
#include "rdata/hs_4/a_1.c"
#include "rdata/generic/ns_2.c"
#include "rdata/generic/md_3.c"
#include "rdata/generic/mf_4.c"
#include "rdata/generic/cname_5.c"
#include "rdata/generic/soa_6.c"
#include "rdata/generic/mb_7.c"
#include "rdata/generic/mg_8.c"
#include "rdata/generic/mr_9.c"
#include "rdata/generic/null_10.c"
#include "rdata/in_1/wks_11.c"
#include "rdata/generic/ptr_12.c"
#include "rdata/generic/hinfo_13.c"
#include "rdata/generic/minfo_14.c"
#include "rdata/generic/mx_15.c"
#include "rdata/generic/txt_16.c"
#include "rdata/generic/rp_17.c"
#include "rdata/generic/afsdb_18.c"
#include "rdata/generic/x25_19.c"
#include "rdata/generic/isdn_20.c"
#include "rdata/generic/rt_21.c"
#include "rdata/in_1/nsap_22.c"
#include "rdata/in_1/nsap-ptr_23.c"
#include "rdata/generic/sig_24.c"
#include "rdata/generic/key_25.c"
#include "rdata/in_1/px_26.c"
#include "rdata/generic/gpos_27.c"
#include "rdata/in_1/aaaa_28.c"
#include "rdata/generic/loc_29.c"
#include "rdata/generic/nxt_30.c"
#include "rdata/in_1/srv_33.c"
#include "rdata/in_1/naptr_35.c"
#include "rdata/in_1/kx_36.c"
#include "rdata/generic/cert_37.c"
#include "rdata/in_1/a6_38.c"
#include "rdata/generic/dname_39.c"
#include "rdata/generic/opt_41.c"
#include "rdata/in_1/apl_42.c"
#include "rdata/generic/ds_43.c"
#include "rdata/generic/sshfp_44.c"
#include "rdata/generic/ipseckey_45.c"
#include "rdata/generic/rrsig_46.c"
#include "rdata/generic/nsec_47.c"
#include "rdata/generic/dnskey_48.c"
#include "rdata/in_1/dhcid_49.c"
#include "rdata/generic/nsec3_50.c"
#include "rdata/generic/nsec3param_51.c"
#include "rdata/generic/spf_99.c"
#include "rdata/generic/unspec_103.c"
#include "rdata/generic/tkey_249.c"
#include "rdata/any_255/tsig_250.c"
#include "rdata/generic/dlv_32769.c"



#define FROMTEXTSWITCH \
	switch (type) { \
	case 1: switch (rdclass) { \
		case 1: result = fromtext_in_a(rdclass, type, lexer, origin, options, target, callbacks); break; \
		case 3: result = fromtext_ch_a(rdclass, type, lexer, origin, options, target, callbacks); break; \
		case 4: result = fromtext_hs_a(rdclass, type, lexer, origin, options, target, callbacks); break; \
		default: result = DNS_R_UNKNOWN; break; \
		} \
		break; \
	case 2: result = fromtext_ns(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 3: result = fromtext_md(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 4: result = fromtext_mf(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 5: result = fromtext_cname(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 6: result = fromtext_soa(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 7: result = fromtext_mb(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 8: result = fromtext_mg(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 9: result = fromtext_mr(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 10: result = fromtext_null(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 11: switch (rdclass) { \
		case 1: result = fromtext_in_wks(rdclass, type, lexer, origin, options, target, callbacks); break; \
		default: result = DNS_R_UNKNOWN; break; \
		} \
		break; \
	case 12: result = fromtext_ptr(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 13: result = fromtext_hinfo(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 14: result = fromtext_minfo(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 15: result = fromtext_mx(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 16: result = fromtext_txt(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 17: result = fromtext_rp(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 18: result = fromtext_afsdb(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 19: result = fromtext_x25(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 20: result = fromtext_isdn(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 21: result = fromtext_rt(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 22: switch (rdclass) { \
		case 1: result = fromtext_in_nsap(rdclass, type, lexer, origin, options, target, callbacks); break; \
		default: result = DNS_R_UNKNOWN; break; \
		} \
		break; \
	case 23: switch (rdclass) { \
		case 1: result = fromtext_in_nsap_ptr(rdclass, type, lexer, origin, options, target, callbacks); break; \
		default: result = DNS_R_UNKNOWN; break; \
		} \
		break; \
	case 24: result = fromtext_sig(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 25: result = fromtext_key(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 26: switch (rdclass) { \
		case 1: result = fromtext_in_px(rdclass, type, lexer, origin, options, target, callbacks); break; \
		default: result = DNS_R_UNKNOWN; break; \
		} \
		break; \
	case 27: result = fromtext_gpos(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 28: switch (rdclass) { \
		case 1: result = fromtext_in_aaaa(rdclass, type, lexer, origin, options, target, callbacks); break; \
		default: result = DNS_R_UNKNOWN; break; \
		} \
		break; \
	case 29: result = fromtext_loc(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 30: result = fromtext_nxt(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 33: switch (rdclass) { \
		case 1: result = fromtext_in_srv(rdclass, type, lexer, origin, options, target, callbacks); break; \
		default: result = DNS_R_UNKNOWN; break; \
		} \
		break; \
	case 35: switch (rdclass) { \
		case 1: result = fromtext_in_naptr(rdclass, type, lexer, origin, options, target, callbacks); break; \
		default: result = DNS_R_UNKNOWN; break; \
		} \
		break; \
	case 36: switch (rdclass) { \
		case 1: result = fromtext_in_kx(rdclass, type, lexer, origin, options, target, callbacks); break; \
		default: result = DNS_R_UNKNOWN; break; \
		} \
		break; \
	case 37: result = fromtext_cert(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 38: switch (rdclass) { \
		case 1: result = fromtext_in_a6(rdclass, type, lexer, origin, options, target, callbacks); break; \
		default: result = DNS_R_UNKNOWN; break; \
		} \
		break; \
	case 39: result = fromtext_dname(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 41: result = fromtext_opt(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 42: switch (rdclass) { \
		case 1: result = fromtext_in_apl(rdclass, type, lexer, origin, options, target, callbacks); break; \
		default: result = DNS_R_UNKNOWN; break; \
		} \
		break; \
	case 43: result = fromtext_ds(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 44: result = fromtext_sshfp(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 45: result = fromtext_ipseckey(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 46: result = fromtext_rrsig(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 47: result = fromtext_nsec(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 48: result = fromtext_dnskey(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 49: switch (rdclass) { \
		case 1: result = fromtext_in_dhcid(rdclass, type, lexer, origin, options, target, callbacks); break; \
		default: result = DNS_R_UNKNOWN; break; \
		} \
		break; \
	case 50: result = fromtext_nsec3(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 51: result = fromtext_nsec3param(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 99: result = fromtext_spf(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 103: result = fromtext_unspec(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 249: result = fromtext_tkey(rdclass, type, lexer, origin, options, target, callbacks); break; \
	case 250: switch (rdclass) { \
		case 255: result = fromtext_any_tsig(rdclass, type, lexer, origin, options, target, callbacks); break; \
		default: result = DNS_R_UNKNOWN; break; \
		} \
		break; \
	case 32769: result = fromtext_dlv(rdclass, type, lexer, origin, options, target, callbacks); break; \
	default: result = DNS_R_UNKNOWN; break; \
	}

#define TOTEXTSWITCH \
	switch (rdata->type) { \
	case 1: switch (rdata->rdclass) { \
		case 1: result = totext_in_a(rdata, tctx, target); break; \
		case 3: result = totext_ch_a(rdata, tctx, target); break; \
		case 4: result = totext_hs_a(rdata, tctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 2: result = totext_ns(rdata, tctx, target); break; \
	case 3: result = totext_md(rdata, tctx, target); break; \
	case 4: result = totext_mf(rdata, tctx, target); break; \
	case 5: result = totext_cname(rdata, tctx, target); break; \
	case 6: result = totext_soa(rdata, tctx, target); break; \
	case 7: result = totext_mb(rdata, tctx, target); break; \
	case 8: result = totext_mg(rdata, tctx, target); break; \
	case 9: result = totext_mr(rdata, tctx, target); break; \
	case 10: result = totext_null(rdata, tctx, target); break; \
	case 11: switch (rdata->rdclass) { \
		case 1: result = totext_in_wks(rdata, tctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 12: result = totext_ptr(rdata, tctx, target); break; \
	case 13: result = totext_hinfo(rdata, tctx, target); break; \
	case 14: result = totext_minfo(rdata, tctx, target); break; \
	case 15: result = totext_mx(rdata, tctx, target); break; \
	case 16: result = totext_txt(rdata, tctx, target); break; \
	case 17: result = totext_rp(rdata, tctx, target); break; \
	case 18: result = totext_afsdb(rdata, tctx, target); break; \
	case 19: result = totext_x25(rdata, tctx, target); break; \
	case 20: result = totext_isdn(rdata, tctx, target); break; \
	case 21: result = totext_rt(rdata, tctx, target); break; \
	case 22: switch (rdata->rdclass) { \
		case 1: result = totext_in_nsap(rdata, tctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 23: switch (rdata->rdclass) { \
		case 1: result = totext_in_nsap_ptr(rdata, tctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 24: result = totext_sig(rdata, tctx, target); break; \
	case 25: result = totext_key(rdata, tctx, target); break; \
	case 26: switch (rdata->rdclass) { \
		case 1: result = totext_in_px(rdata, tctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 27: result = totext_gpos(rdata, tctx, target); break; \
	case 28: switch (rdata->rdclass) { \
		case 1: result = totext_in_aaaa(rdata, tctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 29: result = totext_loc(rdata, tctx, target); break; \
	case 30: result = totext_nxt(rdata, tctx, target); break; \
	case 33: switch (rdata->rdclass) { \
		case 1: result = totext_in_srv(rdata, tctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 35: switch (rdata->rdclass) { \
		case 1: result = totext_in_naptr(rdata, tctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 36: switch (rdata->rdclass) { \
		case 1: result = totext_in_kx(rdata, tctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 37: result = totext_cert(rdata, tctx, target); break; \
	case 38: switch (rdata->rdclass) { \
		case 1: result = totext_in_a6(rdata, tctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 39: result = totext_dname(rdata, tctx, target); break; \
	case 41: result = totext_opt(rdata, tctx, target); break; \
	case 42: switch (rdata->rdclass) { \
		case 1: result = totext_in_apl(rdata, tctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 43: result = totext_ds(rdata, tctx, target); break; \
	case 44: result = totext_sshfp(rdata, tctx, target); break; \
	case 45: result = totext_ipseckey(rdata, tctx, target); break; \
	case 46: result = totext_rrsig(rdata, tctx, target); break; \
	case 47: result = totext_nsec(rdata, tctx, target); break; \
	case 48: result = totext_dnskey(rdata, tctx, target); break; \
	case 49: switch (rdata->rdclass) { \
		case 1: result = totext_in_dhcid(rdata, tctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 50: result = totext_nsec3(rdata, tctx, target); break; \
	case 51: result = totext_nsec3param(rdata, tctx, target); break; \
	case 99: result = totext_spf(rdata, tctx, target); break; \
	case 103: result = totext_unspec(rdata, tctx, target); break; \
	case 249: result = totext_tkey(rdata, tctx, target); break; \
	case 250: switch (rdata->rdclass) { \
		case 255: result = totext_any_tsig(rdata, tctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 32769: result = totext_dlv(rdata, tctx, target); break; \
	default: use_default = ISC_TRUE; break; \
	}

#define FROMWIRESWITCH \
	switch (type) { \
	case 1: switch (rdclass) { \
		case 1: result = fromwire_in_a(rdclass, type, source, dctx, options, target); break; \
		case 3: result = fromwire_ch_a(rdclass, type, source, dctx, options, target); break; \
		case 4: result = fromwire_hs_a(rdclass, type, source, dctx, options, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 2: result = fromwire_ns(rdclass, type, source, dctx, options, target); break; \
	case 3: result = fromwire_md(rdclass, type, source, dctx, options, target); break; \
	case 4: result = fromwire_mf(rdclass, type, source, dctx, options, target); break; \
	case 5: result = fromwire_cname(rdclass, type, source, dctx, options, target); break; \
	case 6: result = fromwire_soa(rdclass, type, source, dctx, options, target); break; \
	case 7: result = fromwire_mb(rdclass, type, source, dctx, options, target); break; \
	case 8: result = fromwire_mg(rdclass, type, source, dctx, options, target); break; \
	case 9: result = fromwire_mr(rdclass, type, source, dctx, options, target); break; \
	case 10: result = fromwire_null(rdclass, type, source, dctx, options, target); break; \
	case 11: switch (rdclass) { \
		case 1: result = fromwire_in_wks(rdclass, type, source, dctx, options, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 12: result = fromwire_ptr(rdclass, type, source, dctx, options, target); break; \
	case 13: result = fromwire_hinfo(rdclass, type, source, dctx, options, target); break; \
	case 14: result = fromwire_minfo(rdclass, type, source, dctx, options, target); break; \
	case 15: result = fromwire_mx(rdclass, type, source, dctx, options, target); break; \
	case 16: result = fromwire_txt(rdclass, type, source, dctx, options, target); break; \
	case 17: result = fromwire_rp(rdclass, type, source, dctx, options, target); break; \
	case 18: result = fromwire_afsdb(rdclass, type, source, dctx, options, target); break; \
	case 19: result = fromwire_x25(rdclass, type, source, dctx, options, target); break; \
	case 20: result = fromwire_isdn(rdclass, type, source, dctx, options, target); break; \
	case 21: result = fromwire_rt(rdclass, type, source, dctx, options, target); break; \
	case 22: switch (rdclass) { \
		case 1: result = fromwire_in_nsap(rdclass, type, source, dctx, options, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 23: switch (rdclass) { \
		case 1: result = fromwire_in_nsap_ptr(rdclass, type, source, dctx, options, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 24: result = fromwire_sig(rdclass, type, source, dctx, options, target); break; \
	case 25: result = fromwire_key(rdclass, type, source, dctx, options, target); break; \
	case 26: switch (rdclass) { \
		case 1: result = fromwire_in_px(rdclass, type, source, dctx, options, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 27: result = fromwire_gpos(rdclass, type, source, dctx, options, target); break; \
	case 28: switch (rdclass) { \
		case 1: result = fromwire_in_aaaa(rdclass, type, source, dctx, options, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 29: result = fromwire_loc(rdclass, type, source, dctx, options, target); break; \
	case 30: result = fromwire_nxt(rdclass, type, source, dctx, options, target); break; \
	case 33: switch (rdclass) { \
		case 1: result = fromwire_in_srv(rdclass, type, source, dctx, options, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 35: switch (rdclass) { \
		case 1: result = fromwire_in_naptr(rdclass, type, source, dctx, options, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 36: switch (rdclass) { \
		case 1: result = fromwire_in_kx(rdclass, type, source, dctx, options, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 37: result = fromwire_cert(rdclass, type, source, dctx, options, target); break; \
	case 38: switch (rdclass) { \
		case 1: result = fromwire_in_a6(rdclass, type, source, dctx, options, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 39: result = fromwire_dname(rdclass, type, source, dctx, options, target); break; \
	case 41: result = fromwire_opt(rdclass, type, source, dctx, options, target); break; \
	case 42: switch (rdclass) { \
		case 1: result = fromwire_in_apl(rdclass, type, source, dctx, options, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 43: result = fromwire_ds(rdclass, type, source, dctx, options, target); break; \
	case 44: result = fromwire_sshfp(rdclass, type, source, dctx, options, target); break; \
	case 45: result = fromwire_ipseckey(rdclass, type, source, dctx, options, target); break; \
	case 46: result = fromwire_rrsig(rdclass, type, source, dctx, options, target); break; \
	case 47: result = fromwire_nsec(rdclass, type, source, dctx, options, target); break; \
	case 48: result = fromwire_dnskey(rdclass, type, source, dctx, options, target); break; \
	case 49: switch (rdclass) { \
		case 1: result = fromwire_in_dhcid(rdclass, type, source, dctx, options, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 50: result = fromwire_nsec3(rdclass, type, source, dctx, options, target); break; \
	case 51: result = fromwire_nsec3param(rdclass, type, source, dctx, options, target); break; \
	case 99: result = fromwire_spf(rdclass, type, source, dctx, options, target); break; \
	case 103: result = fromwire_unspec(rdclass, type, source, dctx, options, target); break; \
	case 249: result = fromwire_tkey(rdclass, type, source, dctx, options, target); break; \
	case 250: switch (rdclass) { \
		case 255: result = fromwire_any_tsig(rdclass, type, source, dctx, options, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 32769: result = fromwire_dlv(rdclass, type, source, dctx, options, target); break; \
	default: use_default = ISC_TRUE; break; \
	}

#define TOWIRESWITCH \
	switch (rdata->type) { \
	case 1: switch (rdata->rdclass) { \
		case 1: result = towire_in_a(rdata, cctx, target); break; \
		case 3: result = towire_ch_a(rdata, cctx, target); break; \
		case 4: result = towire_hs_a(rdata, cctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 2: result = towire_ns(rdata, cctx, target); break; \
	case 3: result = towire_md(rdata, cctx, target); break; \
	case 4: result = towire_mf(rdata, cctx, target); break; \
	case 5: result = towire_cname(rdata, cctx, target); break; \
	case 6: result = towire_soa(rdata, cctx, target); break; \
	case 7: result = towire_mb(rdata, cctx, target); break; \
	case 8: result = towire_mg(rdata, cctx, target); break; \
	case 9: result = towire_mr(rdata, cctx, target); break; \
	case 10: result = towire_null(rdata, cctx, target); break; \
	case 11: switch (rdata->rdclass) { \
		case 1: result = towire_in_wks(rdata, cctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 12: result = towire_ptr(rdata, cctx, target); break; \
	case 13: result = towire_hinfo(rdata, cctx, target); break; \
	case 14: result = towire_minfo(rdata, cctx, target); break; \
	case 15: result = towire_mx(rdata, cctx, target); break; \
	case 16: result = towire_txt(rdata, cctx, target); break; \
	case 17: result = towire_rp(rdata, cctx, target); break; \
	case 18: result = towire_afsdb(rdata, cctx, target); break; \
	case 19: result = towire_x25(rdata, cctx, target); break; \
	case 20: result = towire_isdn(rdata, cctx, target); break; \
	case 21: result = towire_rt(rdata, cctx, target); break; \
	case 22: switch (rdata->rdclass) { \
		case 1: result = towire_in_nsap(rdata, cctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 23: switch (rdata->rdclass) { \
		case 1: result = towire_in_nsap_ptr(rdata, cctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 24: result = towire_sig(rdata, cctx, target); break; \
	case 25: result = towire_key(rdata, cctx, target); break; \
	case 26: switch (rdata->rdclass) { \
		case 1: result = towire_in_px(rdata, cctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 27: result = towire_gpos(rdata, cctx, target); break; \
	case 28: switch (rdata->rdclass) { \
		case 1: result = towire_in_aaaa(rdata, cctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 29: result = towire_loc(rdata, cctx, target); break; \
	case 30: result = towire_nxt(rdata, cctx, target); break; \
	case 33: switch (rdata->rdclass) { \
		case 1: result = towire_in_srv(rdata, cctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 35: switch (rdata->rdclass) { \
		case 1: result = towire_in_naptr(rdata, cctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 36: switch (rdata->rdclass) { \
		case 1: result = towire_in_kx(rdata, cctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 37: result = towire_cert(rdata, cctx, target); break; \
	case 38: switch (rdata->rdclass) { \
		case 1: result = towire_in_a6(rdata, cctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 39: result = towire_dname(rdata, cctx, target); break; \
	case 41: result = towire_opt(rdata, cctx, target); break; \
	case 42: switch (rdata->rdclass) { \
		case 1: result = towire_in_apl(rdata, cctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 43: result = towire_ds(rdata, cctx, target); break; \
	case 44: result = towire_sshfp(rdata, cctx, target); break; \
	case 45: result = towire_ipseckey(rdata, cctx, target); break; \
	case 46: result = towire_rrsig(rdata, cctx, target); break; \
	case 47: result = towire_nsec(rdata, cctx, target); break; \
	case 48: result = towire_dnskey(rdata, cctx, target); break; \
	case 49: switch (rdata->rdclass) { \
		case 1: result = towire_in_dhcid(rdata, cctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 50: result = towire_nsec3(rdata, cctx, target); break; \
	case 51: result = towire_nsec3param(rdata, cctx, target); break; \
	case 99: result = towire_spf(rdata, cctx, target); break; \
	case 103: result = towire_unspec(rdata, cctx, target); break; \
	case 249: result = towire_tkey(rdata, cctx, target); break; \
	case 250: switch (rdata->rdclass) { \
		case 255: result = towire_any_tsig(rdata, cctx, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 32769: result = towire_dlv(rdata, cctx, target); break; \
	default: use_default = ISC_TRUE; break; \
	}

#define COMPARESWITCH \
	switch (rdata1->type) { \
	case 1: switch (rdata1->rdclass) { \
		case 1: result = compare_in_a(rdata1, rdata2); break; \
		case 3: result = compare_ch_a(rdata1, rdata2); break; \
		case 4: result = compare_hs_a(rdata1, rdata2); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 2: result = compare_ns(rdata1, rdata2); break; \
	case 3: result = compare_md(rdata1, rdata2); break; \
	case 4: result = compare_mf(rdata1, rdata2); break; \
	case 5: result = compare_cname(rdata1, rdata2); break; \
	case 6: result = compare_soa(rdata1, rdata2); break; \
	case 7: result = compare_mb(rdata1, rdata2); break; \
	case 8: result = compare_mg(rdata1, rdata2); break; \
	case 9: result = compare_mr(rdata1, rdata2); break; \
	case 10: result = compare_null(rdata1, rdata2); break; \
	case 11: switch (rdata1->rdclass) { \
		case 1: result = compare_in_wks(rdata1, rdata2); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 12: result = compare_ptr(rdata1, rdata2); break; \
	case 13: result = compare_hinfo(rdata1, rdata2); break; \
	case 14: result = compare_minfo(rdata1, rdata2); break; \
	case 15: result = compare_mx(rdata1, rdata2); break; \
	case 16: result = compare_txt(rdata1, rdata2); break; \
	case 17: result = compare_rp(rdata1, rdata2); break; \
	case 18: result = compare_afsdb(rdata1, rdata2); break; \
	case 19: result = compare_x25(rdata1, rdata2); break; \
	case 20: result = compare_isdn(rdata1, rdata2); break; \
	case 21: result = compare_rt(rdata1, rdata2); break; \
	case 22: switch (rdata1->rdclass) { \
		case 1: result = compare_in_nsap(rdata1, rdata2); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 23: switch (rdata1->rdclass) { \
		case 1: result = compare_in_nsap_ptr(rdata1, rdata2); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 24: result = compare_sig(rdata1, rdata2); break; \
	case 25: result = compare_key(rdata1, rdata2); break; \
	case 26: switch (rdata1->rdclass) { \
		case 1: result = compare_in_px(rdata1, rdata2); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 27: result = compare_gpos(rdata1, rdata2); break; \
	case 28: switch (rdata1->rdclass) { \
		case 1: result = compare_in_aaaa(rdata1, rdata2); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 29: result = compare_loc(rdata1, rdata2); break; \
	case 30: result = compare_nxt(rdata1, rdata2); break; \
	case 33: switch (rdata1->rdclass) { \
		case 1: result = compare_in_srv(rdata1, rdata2); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 35: switch (rdata1->rdclass) { \
		case 1: result = compare_in_naptr(rdata1, rdata2); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 36: switch (rdata1->rdclass) { \
		case 1: result = compare_in_kx(rdata1, rdata2); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 37: result = compare_cert(rdata1, rdata2); break; \
	case 38: switch (rdata1->rdclass) { \
		case 1: result = compare_in_a6(rdata1, rdata2); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 39: result = compare_dname(rdata1, rdata2); break; \
	case 41: result = compare_opt(rdata1, rdata2); break; \
	case 42: switch (rdata1->rdclass) { \
		case 1: result = compare_in_apl(rdata1, rdata2); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 43: result = compare_ds(rdata1, rdata2); break; \
	case 44: result = compare_sshfp(rdata1, rdata2); break; \
	case 45: result = compare_ipseckey(rdata1, rdata2); break; \
	case 46: result = compare_rrsig(rdata1, rdata2); break; \
	case 47: result = compare_nsec(rdata1, rdata2); break; \
	case 48: result = compare_dnskey(rdata1, rdata2); break; \
	case 49: switch (rdata1->rdclass) { \
		case 1: result = compare_in_dhcid(rdata1, rdata2); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 50: result = compare_nsec3(rdata1, rdata2); break; \
	case 51: result = compare_nsec3param(rdata1, rdata2); break; \
	case 99: result = compare_spf(rdata1, rdata2); break; \
	case 103: result = compare_unspec(rdata1, rdata2); break; \
	case 249: result = compare_tkey(rdata1, rdata2); break; \
	case 250: switch (rdata1->rdclass) { \
		case 255: result = compare_any_tsig(rdata1, rdata2); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 32769: result = compare_dlv(rdata1, rdata2); break; \
	default: use_default = ISC_TRUE; break; \
	}

#define FROMSTRUCTSWITCH \
	switch (type) { \
	case 1: switch (rdclass) { \
		case 1: result = fromstruct_in_a(rdclass, type, source, target); break; \
		case 3: result = fromstruct_ch_a(rdclass, type, source, target); break; \
		case 4: result = fromstruct_hs_a(rdclass, type, source, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 2: result = fromstruct_ns(rdclass, type, source, target); break; \
	case 3: result = fromstruct_md(rdclass, type, source, target); break; \
	case 4: result = fromstruct_mf(rdclass, type, source, target); break; \
	case 5: result = fromstruct_cname(rdclass, type, source, target); break; \
	case 6: result = fromstruct_soa(rdclass, type, source, target); break; \
	case 7: result = fromstruct_mb(rdclass, type, source, target); break; \
	case 8: result = fromstruct_mg(rdclass, type, source, target); break; \
	case 9: result = fromstruct_mr(rdclass, type, source, target); break; \
	case 10: result = fromstruct_null(rdclass, type, source, target); break; \
	case 11: switch (rdclass) { \
		case 1: result = fromstruct_in_wks(rdclass, type, source, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 12: result = fromstruct_ptr(rdclass, type, source, target); break; \
	case 13: result = fromstruct_hinfo(rdclass, type, source, target); break; \
	case 14: result = fromstruct_minfo(rdclass, type, source, target); break; \
	case 15: result = fromstruct_mx(rdclass, type, source, target); break; \
	case 16: result = fromstruct_txt(rdclass, type, source, target); break; \
	case 17: result = fromstruct_rp(rdclass, type, source, target); break; \
	case 18: result = fromstruct_afsdb(rdclass, type, source, target); break; \
	case 19: result = fromstruct_x25(rdclass, type, source, target); break; \
	case 20: result = fromstruct_isdn(rdclass, type, source, target); break; \
	case 21: result = fromstruct_rt(rdclass, type, source, target); break; \
	case 22: switch (rdclass) { \
		case 1: result = fromstruct_in_nsap(rdclass, type, source, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 23: switch (rdclass) { \
		case 1: result = fromstruct_in_nsap_ptr(rdclass, type, source, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 24: result = fromstruct_sig(rdclass, type, source, target); break; \
	case 25: result = fromstruct_key(rdclass, type, source, target); break; \
	case 26: switch (rdclass) { \
		case 1: result = fromstruct_in_px(rdclass, type, source, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 27: result = fromstruct_gpos(rdclass, type, source, target); break; \
	case 28: switch (rdclass) { \
		case 1: result = fromstruct_in_aaaa(rdclass, type, source, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 29: result = fromstruct_loc(rdclass, type, source, target); break; \
	case 30: result = fromstruct_nxt(rdclass, type, source, target); break; \
	case 33: switch (rdclass) { \
		case 1: result = fromstruct_in_srv(rdclass, type, source, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 35: switch (rdclass) { \
		case 1: result = fromstruct_in_naptr(rdclass, type, source, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 36: switch (rdclass) { \
		case 1: result = fromstruct_in_kx(rdclass, type, source, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 37: result = fromstruct_cert(rdclass, type, source, target); break; \
	case 38: switch (rdclass) { \
		case 1: result = fromstruct_in_a6(rdclass, type, source, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 39: result = fromstruct_dname(rdclass, type, source, target); break; \
	case 41: result = fromstruct_opt(rdclass, type, source, target); break; \
	case 42: switch (rdclass) { \
		case 1: result = fromstruct_in_apl(rdclass, type, source, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 43: result = fromstruct_ds(rdclass, type, source, target); break; \
	case 44: result = fromstruct_sshfp(rdclass, type, source, target); break; \
	case 45: result = fromstruct_ipseckey(rdclass, type, source, target); break; \
	case 46: result = fromstruct_rrsig(rdclass, type, source, target); break; \
	case 47: result = fromstruct_nsec(rdclass, type, source, target); break; \
	case 48: result = fromstruct_dnskey(rdclass, type, source, target); break; \
	case 49: switch (rdclass) { \
		case 1: result = fromstruct_in_dhcid(rdclass, type, source, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 50: result = fromstruct_nsec3(rdclass, type, source, target); break; \
	case 51: result = fromstruct_nsec3param(rdclass, type, source, target); break; \
	case 99: result = fromstruct_spf(rdclass, type, source, target); break; \
	case 103: result = fromstruct_unspec(rdclass, type, source, target); break; \
	case 249: result = fromstruct_tkey(rdclass, type, source, target); break; \
	case 250: switch (rdclass) { \
		case 255: result = fromstruct_any_tsig(rdclass, type, source, target); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 32769: result = fromstruct_dlv(rdclass, type, source, target); break; \
	default: use_default = ISC_TRUE; break; \
	}

#define TOSTRUCTSWITCH \
	switch (rdata->type) { \
	case 1: switch (rdata->rdclass) { \
		case 1: result = tostruct_in_a(rdata, target, mctx); break; \
		case 3: result = tostruct_ch_a(rdata, target, mctx); break; \
		case 4: result = tostruct_hs_a(rdata, target, mctx); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 2: result = tostruct_ns(rdata, target, mctx); break; \
	case 3: result = tostruct_md(rdata, target, mctx); break; \
	case 4: result = tostruct_mf(rdata, target, mctx); break; \
	case 5: result = tostruct_cname(rdata, target, mctx); break; \
	case 6: result = tostruct_soa(rdata, target, mctx); break; \
	case 7: result = tostruct_mb(rdata, target, mctx); break; \
	case 8: result = tostruct_mg(rdata, target, mctx); break; \
	case 9: result = tostruct_mr(rdata, target, mctx); break; \
	case 10: result = tostruct_null(rdata, target, mctx); break; \
	case 11: switch (rdata->rdclass) { \
		case 1: result = tostruct_in_wks(rdata, target, mctx); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 12: result = tostruct_ptr(rdata, target, mctx); break; \
	case 13: result = tostruct_hinfo(rdata, target, mctx); break; \
	case 14: result = tostruct_minfo(rdata, target, mctx); break; \
	case 15: result = tostruct_mx(rdata, target, mctx); break; \
	case 16: result = tostruct_txt(rdata, target, mctx); break; \
	case 17: result = tostruct_rp(rdata, target, mctx); break; \
	case 18: result = tostruct_afsdb(rdata, target, mctx); break; \
	case 19: result = tostruct_x25(rdata, target, mctx); break; \
	case 20: result = tostruct_isdn(rdata, target, mctx); break; \
	case 21: result = tostruct_rt(rdata, target, mctx); break; \
	case 22: switch (rdata->rdclass) { \
		case 1: result = tostruct_in_nsap(rdata, target, mctx); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 23: switch (rdata->rdclass) { \
		case 1: result = tostruct_in_nsap_ptr(rdata, target, mctx); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 24: result = tostruct_sig(rdata, target, mctx); break; \
	case 25: result = tostruct_key(rdata, target, mctx); break; \
	case 26: switch (rdata->rdclass) { \
		case 1: result = tostruct_in_px(rdata, target, mctx); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 27: result = tostruct_gpos(rdata, target, mctx); break; \
	case 28: switch (rdata->rdclass) { \
		case 1: result = tostruct_in_aaaa(rdata, target, mctx); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 29: result = tostruct_loc(rdata, target, mctx); break; \
	case 30: result = tostruct_nxt(rdata, target, mctx); break; \
	case 33: switch (rdata->rdclass) { \
		case 1: result = tostruct_in_srv(rdata, target, mctx); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 35: switch (rdata->rdclass) { \
		case 1: result = tostruct_in_naptr(rdata, target, mctx); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 36: switch (rdata->rdclass) { \
		case 1: result = tostruct_in_kx(rdata, target, mctx); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 37: result = tostruct_cert(rdata, target, mctx); break; \
	case 38: switch (rdata->rdclass) { \
		case 1: result = tostruct_in_a6(rdata, target, mctx); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 39: result = tostruct_dname(rdata, target, mctx); break; \
	case 41: result = tostruct_opt(rdata, target, mctx); break; \
	case 42: switch (rdata->rdclass) { \
		case 1: result = tostruct_in_apl(rdata, target, mctx); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 43: result = tostruct_ds(rdata, target, mctx); break; \
	case 44: result = tostruct_sshfp(rdata, target, mctx); break; \
	case 45: result = tostruct_ipseckey(rdata, target, mctx); break; \
	case 46: result = tostruct_rrsig(rdata, target, mctx); break; \
	case 47: result = tostruct_nsec(rdata, target, mctx); break; \
	case 48: result = tostruct_dnskey(rdata, target, mctx); break; \
	case 49: switch (rdata->rdclass) { \
		case 1: result = tostruct_in_dhcid(rdata, target, mctx); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 50: result = tostruct_nsec3(rdata, target, mctx); break; \
	case 51: result = tostruct_nsec3param(rdata, target, mctx); break; \
	case 99: result = tostruct_spf(rdata, target, mctx); break; \
	case 103: result = tostruct_unspec(rdata, target, mctx); break; \
	case 249: result = tostruct_tkey(rdata, target, mctx); break; \
	case 250: switch (rdata->rdclass) { \
		case 255: result = tostruct_any_tsig(rdata, target, mctx); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 32769: result = tostruct_dlv(rdata, target, mctx); break; \
	default: use_default = ISC_TRUE; break; \
	}

#define FREESTRUCTSWITCH \
	switch (common->rdtype) { \
	case 1: switch (common->rdclass) { \
		case 1: freestruct_in_a(source); break; \
		case 3: freestruct_ch_a(source); break; \
		case 4: freestruct_hs_a(source); break; \
		default: break; \
		} \
		break; \
	case 2: freestruct_ns(source); break; \
	case 3: freestruct_md(source); break; \
	case 4: freestruct_mf(source); break; \
	case 5: freestruct_cname(source); break; \
	case 6: freestruct_soa(source); break; \
	case 7: freestruct_mb(source); break; \
	case 8: freestruct_mg(source); break; \
	case 9: freestruct_mr(source); break; \
	case 10: freestruct_null(source); break; \
	case 11: switch (common->rdclass) { \
		case 1: freestruct_in_wks(source); break; \
		default: break; \
		} \
		break; \
	case 12: freestruct_ptr(source); break; \
	case 13: freestruct_hinfo(source); break; \
	case 14: freestruct_minfo(source); break; \
	case 15: freestruct_mx(source); break; \
	case 16: freestruct_txt(source); break; \
	case 17: freestruct_rp(source); break; \
	case 18: freestruct_afsdb(source); break; \
	case 19: freestruct_x25(source); break; \
	case 20: freestruct_isdn(source); break; \
	case 21: freestruct_rt(source); break; \
	case 22: switch (common->rdclass) { \
		case 1: freestruct_in_nsap(source); break; \
		default: break; \
		} \
		break; \
	case 23: switch (common->rdclass) { \
		case 1: freestruct_in_nsap_ptr(source); break; \
		default: break; \
		} \
		break; \
	case 24: freestruct_sig(source); break; \
	case 25: freestruct_key(source); break; \
	case 26: switch (common->rdclass) { \
		case 1: freestruct_in_px(source); break; \
		default: break; \
		} \
		break; \
	case 27: freestruct_gpos(source); break; \
	case 28: switch (common->rdclass) { \
		case 1: freestruct_in_aaaa(source); break; \
		default: break; \
		} \
		break; \
	case 29: freestruct_loc(source); break; \
	case 30: freestruct_nxt(source); break; \
	case 33: switch (common->rdclass) { \
		case 1: freestruct_in_srv(source); break; \
		default: break; \
		} \
		break; \
	case 35: switch (common->rdclass) { \
		case 1: freestruct_in_naptr(source); break; \
		default: break; \
		} \
		break; \
	case 36: switch (common->rdclass) { \
		case 1: freestruct_in_kx(source); break; \
		default: break; \
		} \
		break; \
	case 37: freestruct_cert(source); break; \
	case 38: switch (common->rdclass) { \
		case 1: freestruct_in_a6(source); break; \
		default: break; \
		} \
		break; \
	case 39: freestruct_dname(source); break; \
	case 41: freestruct_opt(source); break; \
	case 42: switch (common->rdclass) { \
		case 1: freestruct_in_apl(source); break; \
		default: break; \
		} \
		break; \
	case 43: freestruct_ds(source); break; \
	case 44: freestruct_sshfp(source); break; \
	case 45: freestruct_ipseckey(source); break; \
	case 46: freestruct_rrsig(source); break; \
	case 47: freestruct_nsec(source); break; \
	case 48: freestruct_dnskey(source); break; \
	case 49: switch (common->rdclass) { \
		case 1: freestruct_in_dhcid(source); break; \
		default: break; \
		} \
		break; \
	case 50: freestruct_nsec3(source); break; \
	case 51: freestruct_nsec3param(source); break; \
	case 99: freestruct_spf(source); break; \
	case 103: freestruct_unspec(source); break; \
	case 249: freestruct_tkey(source); break; \
	case 250: switch (common->rdclass) { \
		case 255: freestruct_any_tsig(source); break; \
		default: break; \
		} \
		break; \
	case 32769: freestruct_dlv(source); break; \
	default: break; \
	}

#define ADDITIONALDATASWITCH \
	switch (rdata->type) { \
	case 1: switch (rdata->rdclass) { \
		case 1: result = additionaldata_in_a(rdata, add, arg); break; \
		case 3: result = additionaldata_ch_a(rdata, add, arg); break; \
		case 4: result = additionaldata_hs_a(rdata, add, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 2: result = additionaldata_ns(rdata, add, arg); break; \
	case 3: result = additionaldata_md(rdata, add, arg); break; \
	case 4: result = additionaldata_mf(rdata, add, arg); break; \
	case 5: result = additionaldata_cname(rdata, add, arg); break; \
	case 6: result = additionaldata_soa(rdata, add, arg); break; \
	case 7: result = additionaldata_mb(rdata, add, arg); break; \
	case 8: result = additionaldata_mg(rdata, add, arg); break; \
	case 9: result = additionaldata_mr(rdata, add, arg); break; \
	case 10: result = additionaldata_null(rdata, add, arg); break; \
	case 11: switch (rdata->rdclass) { \
		case 1: result = additionaldata_in_wks(rdata, add, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 12: result = additionaldata_ptr(rdata, add, arg); break; \
	case 13: result = additionaldata_hinfo(rdata, add, arg); break; \
	case 14: result = additionaldata_minfo(rdata, add, arg); break; \
	case 15: result = additionaldata_mx(rdata, add, arg); break; \
	case 16: result = additionaldata_txt(rdata, add, arg); break; \
	case 17: result = additionaldata_rp(rdata, add, arg); break; \
	case 18: result = additionaldata_afsdb(rdata, add, arg); break; \
	case 19: result = additionaldata_x25(rdata, add, arg); break; \
	case 20: result = additionaldata_isdn(rdata, add, arg); break; \
	case 21: result = additionaldata_rt(rdata, add, arg); break; \
	case 22: switch (rdata->rdclass) { \
		case 1: result = additionaldata_in_nsap(rdata, add, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 23: switch (rdata->rdclass) { \
		case 1: result = additionaldata_in_nsap_ptr(rdata, add, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 24: result = additionaldata_sig(rdata, add, arg); break; \
	case 25: result = additionaldata_key(rdata, add, arg); break; \
	case 26: switch (rdata->rdclass) { \
		case 1: result = additionaldata_in_px(rdata, add, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 27: result = additionaldata_gpos(rdata, add, arg); break; \
	case 28: switch (rdata->rdclass) { \
		case 1: result = additionaldata_in_aaaa(rdata, add, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 29: result = additionaldata_loc(rdata, add, arg); break; \
	case 30: result = additionaldata_nxt(rdata, add, arg); break; \
	case 33: switch (rdata->rdclass) { \
		case 1: result = additionaldata_in_srv(rdata, add, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 35: switch (rdata->rdclass) { \
		case 1: result = additionaldata_in_naptr(rdata, add, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 36: switch (rdata->rdclass) { \
		case 1: result = additionaldata_in_kx(rdata, add, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 37: result = additionaldata_cert(rdata, add, arg); break; \
	case 38: switch (rdata->rdclass) { \
		case 1: result = additionaldata_in_a6(rdata, add, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 39: result = additionaldata_dname(rdata, add, arg); break; \
	case 41: result = additionaldata_opt(rdata, add, arg); break; \
	case 42: switch (rdata->rdclass) { \
		case 1: result = additionaldata_in_apl(rdata, add, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 43: result = additionaldata_ds(rdata, add, arg); break; \
	case 44: result = additionaldata_sshfp(rdata, add, arg); break; \
	case 45: result = additionaldata_ipseckey(rdata, add, arg); break; \
	case 46: result = additionaldata_rrsig(rdata, add, arg); break; \
	case 47: result = additionaldata_nsec(rdata, add, arg); break; \
	case 48: result = additionaldata_dnskey(rdata, add, arg); break; \
	case 49: switch (rdata->rdclass) { \
		case 1: result = additionaldata_in_dhcid(rdata, add, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 50: result = additionaldata_nsec3(rdata, add, arg); break; \
	case 51: result = additionaldata_nsec3param(rdata, add, arg); break; \
	case 99: result = additionaldata_spf(rdata, add, arg); break; \
	case 103: result = additionaldata_unspec(rdata, add, arg); break; \
	case 249: result = additionaldata_tkey(rdata, add, arg); break; \
	case 250: switch (rdata->rdclass) { \
		case 255: result = additionaldata_any_tsig(rdata, add, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 32769: result = additionaldata_dlv(rdata, add, arg); break; \
	default: use_default = ISC_TRUE; break; \
	}

#define DIGESTSWITCH \
	switch (rdata->type) { \
	case 1: switch (rdata->rdclass) { \
		case 1: result = digest_in_a(rdata, digest, arg); break; \
		case 3: result = digest_ch_a(rdata, digest, arg); break; \
		case 4: result = digest_hs_a(rdata, digest, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 2: result = digest_ns(rdata, digest, arg); break; \
	case 3: result = digest_md(rdata, digest, arg); break; \
	case 4: result = digest_mf(rdata, digest, arg); break; \
	case 5: result = digest_cname(rdata, digest, arg); break; \
	case 6: result = digest_soa(rdata, digest, arg); break; \
	case 7: result = digest_mb(rdata, digest, arg); break; \
	case 8: result = digest_mg(rdata, digest, arg); break; \
	case 9: result = digest_mr(rdata, digest, arg); break; \
	case 10: result = digest_null(rdata, digest, arg); break; \
	case 11: switch (rdata->rdclass) { \
		case 1: result = digest_in_wks(rdata, digest, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 12: result = digest_ptr(rdata, digest, arg); break; \
	case 13: result = digest_hinfo(rdata, digest, arg); break; \
	case 14: result = digest_minfo(rdata, digest, arg); break; \
	case 15: result = digest_mx(rdata, digest, arg); break; \
	case 16: result = digest_txt(rdata, digest, arg); break; \
	case 17: result = digest_rp(rdata, digest, arg); break; \
	case 18: result = digest_afsdb(rdata, digest, arg); break; \
	case 19: result = digest_x25(rdata, digest, arg); break; \
	case 20: result = digest_isdn(rdata, digest, arg); break; \
	case 21: result = digest_rt(rdata, digest, arg); break; \
	case 22: switch (rdata->rdclass) { \
		case 1: result = digest_in_nsap(rdata, digest, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 23: switch (rdata->rdclass) { \
		case 1: result = digest_in_nsap_ptr(rdata, digest, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 24: result = digest_sig(rdata, digest, arg); break; \
	case 25: result = digest_key(rdata, digest, arg); break; \
	case 26: switch (rdata->rdclass) { \
		case 1: result = digest_in_px(rdata, digest, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 27: result = digest_gpos(rdata, digest, arg); break; \
	case 28: switch (rdata->rdclass) { \
		case 1: result = digest_in_aaaa(rdata, digest, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 29: result = digest_loc(rdata, digest, arg); break; \
	case 30: result = digest_nxt(rdata, digest, arg); break; \
	case 33: switch (rdata->rdclass) { \
		case 1: result = digest_in_srv(rdata, digest, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 35: switch (rdata->rdclass) { \
		case 1: result = digest_in_naptr(rdata, digest, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 36: switch (rdata->rdclass) { \
		case 1: result = digest_in_kx(rdata, digest, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 37: result = digest_cert(rdata, digest, arg); break; \
	case 38: switch (rdata->rdclass) { \
		case 1: result = digest_in_a6(rdata, digest, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 39: result = digest_dname(rdata, digest, arg); break; \
	case 41: result = digest_opt(rdata, digest, arg); break; \
	case 42: switch (rdata->rdclass) { \
		case 1: result = digest_in_apl(rdata, digest, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 43: result = digest_ds(rdata, digest, arg); break; \
	case 44: result = digest_sshfp(rdata, digest, arg); break; \
	case 45: result = digest_ipseckey(rdata, digest, arg); break; \
	case 46: result = digest_rrsig(rdata, digest, arg); break; \
	case 47: result = digest_nsec(rdata, digest, arg); break; \
	case 48: result = digest_dnskey(rdata, digest, arg); break; \
	case 49: switch (rdata->rdclass) { \
		case 1: result = digest_in_dhcid(rdata, digest, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 50: result = digest_nsec3(rdata, digest, arg); break; \
	case 51: result = digest_nsec3param(rdata, digest, arg); break; \
	case 99: result = digest_spf(rdata, digest, arg); break; \
	case 103: result = digest_unspec(rdata, digest, arg); break; \
	case 249: result = digest_tkey(rdata, digest, arg); break; \
	case 250: switch (rdata->rdclass) { \
		case 255: result = digest_any_tsig(rdata, digest, arg); break; \
		default: use_default = ISC_TRUE; break; \
		} \
		break; \
	case 32769: result = digest_dlv(rdata, digest, arg); break; \
	default: use_default = ISC_TRUE; break; \
	}

#define CHECKOWNERSWITCH \
	switch (type) { \
	case 1: switch (rdclass) { \
		case 1: result = checkowner_in_a(name, rdclass, type, wildcard); break; \
		case 3: result = checkowner_ch_a(name, rdclass, type, wildcard); break; \
		case 4: result = checkowner_hs_a(name, rdclass, type, wildcard); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 2: result = checkowner_ns(name, rdclass, type, wildcard); break; \
	case 3: result = checkowner_md(name, rdclass, type, wildcard); break; \
	case 4: result = checkowner_mf(name, rdclass, type, wildcard); break; \
	case 5: result = checkowner_cname(name, rdclass, type, wildcard); break; \
	case 6: result = checkowner_soa(name, rdclass, type, wildcard); break; \
	case 7: result = checkowner_mb(name, rdclass, type, wildcard); break; \
	case 8: result = checkowner_mg(name, rdclass, type, wildcard); break; \
	case 9: result = checkowner_mr(name, rdclass, type, wildcard); break; \
	case 10: result = checkowner_null(name, rdclass, type, wildcard); break; \
	case 11: switch (rdclass) { \
		case 1: result = checkowner_in_wks(name, rdclass, type, wildcard); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 12: result = checkowner_ptr(name, rdclass, type, wildcard); break; \
	case 13: result = checkowner_hinfo(name, rdclass, type, wildcard); break; \
	case 14: result = checkowner_minfo(name, rdclass, type, wildcard); break; \
	case 15: result = checkowner_mx(name, rdclass, type, wildcard); break; \
	case 16: result = checkowner_txt(name, rdclass, type, wildcard); break; \
	case 17: result = checkowner_rp(name, rdclass, type, wildcard); break; \
	case 18: result = checkowner_afsdb(name, rdclass, type, wildcard); break; \
	case 19: result = checkowner_x25(name, rdclass, type, wildcard); break; \
	case 20: result = checkowner_isdn(name, rdclass, type, wildcard); break; \
	case 21: result = checkowner_rt(name, rdclass, type, wildcard); break; \
	case 22: switch (rdclass) { \
		case 1: result = checkowner_in_nsap(name, rdclass, type, wildcard); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 23: switch (rdclass) { \
		case 1: result = checkowner_in_nsap_ptr(name, rdclass, type, wildcard); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 24: result = checkowner_sig(name, rdclass, type, wildcard); break; \
	case 25: result = checkowner_key(name, rdclass, type, wildcard); break; \
	case 26: switch (rdclass) { \
		case 1: result = checkowner_in_px(name, rdclass, type, wildcard); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 27: result = checkowner_gpos(name, rdclass, type, wildcard); break; \
	case 28: switch (rdclass) { \
		case 1: result = checkowner_in_aaaa(name, rdclass, type, wildcard); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 29: result = checkowner_loc(name, rdclass, type, wildcard); break; \
	case 30: result = checkowner_nxt(name, rdclass, type, wildcard); break; \
	case 33: switch (rdclass) { \
		case 1: result = checkowner_in_srv(name, rdclass, type, wildcard); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 35: switch (rdclass) { \
		case 1: result = checkowner_in_naptr(name, rdclass, type, wildcard); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 36: switch (rdclass) { \
		case 1: result = checkowner_in_kx(name, rdclass, type, wildcard); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 37: result = checkowner_cert(name, rdclass, type, wildcard); break; \
	case 38: switch (rdclass) { \
		case 1: result = checkowner_in_a6(name, rdclass, type, wildcard); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 39: result = checkowner_dname(name, rdclass, type, wildcard); break; \
	case 41: result = checkowner_opt(name, rdclass, type, wildcard); break; \
	case 42: switch (rdclass) { \
		case 1: result = checkowner_in_apl(name, rdclass, type, wildcard); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 43: result = checkowner_ds(name, rdclass, type, wildcard); break; \
	case 44: result = checkowner_sshfp(name, rdclass, type, wildcard); break; \
	case 45: result = checkowner_ipseckey(name, rdclass, type, wildcard); break; \
	case 46: result = checkowner_rrsig(name, rdclass, type, wildcard); break; \
	case 47: result = checkowner_nsec(name, rdclass, type, wildcard); break; \
	case 48: result = checkowner_dnskey(name, rdclass, type, wildcard); break; \
	case 49: switch (rdclass) { \
		case 1: result = checkowner_in_dhcid(name, rdclass, type, wildcard); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 50: result = checkowner_nsec3(name, rdclass, type, wildcard); break; \
	case 51: result = checkowner_nsec3param(name, rdclass, type, wildcard); break; \
	case 99: result = checkowner_spf(name, rdclass, type, wildcard); break; \
	case 103: result = checkowner_unspec(name, rdclass, type, wildcard); break; \
	case 249: result = checkowner_tkey(name, rdclass, type, wildcard); break; \
	case 250: switch (rdclass) { \
		case 255: result = checkowner_any_tsig(name, rdclass, type, wildcard); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 32769: result = checkowner_dlv(name, rdclass, type, wildcard); break; \
	default: result = ISC_TRUE; break; \
	}

#define CHECKNAMESSWITCH \
	switch (rdata->type) { \
	case 1: switch (rdata->rdclass) { \
		case 1: result = checknames_in_a(rdata, owner, bad); break; \
		case 3: result = checknames_ch_a(rdata, owner, bad); break; \
		case 4: result = checknames_hs_a(rdata, owner, bad); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 2: result = checknames_ns(rdata, owner, bad); break; \
	case 3: result = checknames_md(rdata, owner, bad); break; \
	case 4: result = checknames_mf(rdata, owner, bad); break; \
	case 5: result = checknames_cname(rdata, owner, bad); break; \
	case 6: result = checknames_soa(rdata, owner, bad); break; \
	case 7: result = checknames_mb(rdata, owner, bad); break; \
	case 8: result = checknames_mg(rdata, owner, bad); break; \
	case 9: result = checknames_mr(rdata, owner, bad); break; \
	case 10: result = checknames_null(rdata, owner, bad); break; \
	case 11: switch (rdata->rdclass) { \
		case 1: result = checknames_in_wks(rdata, owner, bad); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 12: result = checknames_ptr(rdata, owner, bad); break; \
	case 13: result = checknames_hinfo(rdata, owner, bad); break; \
	case 14: result = checknames_minfo(rdata, owner, bad); break; \
	case 15: result = checknames_mx(rdata, owner, bad); break; \
	case 16: result = checknames_txt(rdata, owner, bad); break; \
	case 17: result = checknames_rp(rdata, owner, bad); break; \
	case 18: result = checknames_afsdb(rdata, owner, bad); break; \
	case 19: result = checknames_x25(rdata, owner, bad); break; \
	case 20: result = checknames_isdn(rdata, owner, bad); break; \
	case 21: result = checknames_rt(rdata, owner, bad); break; \
	case 22: switch (rdata->rdclass) { \
		case 1: result = checknames_in_nsap(rdata, owner, bad); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 23: switch (rdata->rdclass) { \
		case 1: result = checknames_in_nsap_ptr(rdata, owner, bad); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 24: result = checknames_sig(rdata, owner, bad); break; \
	case 25: result = checknames_key(rdata, owner, bad); break; \
	case 26: switch (rdata->rdclass) { \
		case 1: result = checknames_in_px(rdata, owner, bad); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 27: result = checknames_gpos(rdata, owner, bad); break; \
	case 28: switch (rdata->rdclass) { \
		case 1: result = checknames_in_aaaa(rdata, owner, bad); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 29: result = checknames_loc(rdata, owner, bad); break; \
	case 30: result = checknames_nxt(rdata, owner, bad); break; \
	case 33: switch (rdata->rdclass) { \
		case 1: result = checknames_in_srv(rdata, owner, bad); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 35: switch (rdata->rdclass) { \
		case 1: result = checknames_in_naptr(rdata, owner, bad); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 36: switch (rdata->rdclass) { \
		case 1: result = checknames_in_kx(rdata, owner, bad); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 37: result = checknames_cert(rdata, owner, bad); break; \
	case 38: switch (rdata->rdclass) { \
		case 1: result = checknames_in_a6(rdata, owner, bad); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 39: result = checknames_dname(rdata, owner, bad); break; \
	case 41: result = checknames_opt(rdata, owner, bad); break; \
	case 42: switch (rdata->rdclass) { \
		case 1: result = checknames_in_apl(rdata, owner, bad); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 43: result = checknames_ds(rdata, owner, bad); break; \
	case 44: result = checknames_sshfp(rdata, owner, bad); break; \
	case 45: result = checknames_ipseckey(rdata, owner, bad); break; \
	case 46: result = checknames_rrsig(rdata, owner, bad); break; \
	case 47: result = checknames_nsec(rdata, owner, bad); break; \
	case 48: result = checknames_dnskey(rdata, owner, bad); break; \
	case 49: switch (rdata->rdclass) { \
		case 1: result = checknames_in_dhcid(rdata, owner, bad); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 50: result = checknames_nsec3(rdata, owner, bad); break; \
	case 51: result = checknames_nsec3param(rdata, owner, bad); break; \
	case 99: result = checknames_spf(rdata, owner, bad); break; \
	case 103: result = checknames_unspec(rdata, owner, bad); break; \
	case 249: result = checknames_tkey(rdata, owner, bad); break; \
	case 250: switch (rdata->rdclass) { \
		case 255: result = checknames_any_tsig(rdata, owner, bad); break; \
		default: result = ISC_TRUE; break; \
		} \
		break; \
	case 32769: result = checknames_dlv(rdata, owner, bad); break; \
	default: result = ISC_TRUE; break; \
	}
#define RDATATYPE_COMPARE(_s, _d, _tn, _n, _tp) \
	do { \
		if (sizeof(_s) - 1 == _n && \
		    strncasecmp(_s,(_tn),(sizeof(_s) - 1)) == 0) { \
			if ((dns_rdatatype_attributes(_d) & DNS_RDATATYPEATTR_RESERVED) != 0) \
				return (ISC_R_NOTIMPLEMENTED); \
			*(_tp) = _d; \
			return (ISC_R_SUCCESS); \
		} \
	} while (0)

#define RDATATYPE_FROMTEXT_SW(_hash,_typename,_length,_typep) \
	switch (_hash) { \
		case 16: \
			RDATATYPE_COMPARE("reserved0", 0, _typename, _length, _typep); \
			break; \
		case 34: \
			RDATATYPE_COMPARE("a", 1, _typename, _length, _typep); \
			break; \
		case 80: \
			RDATATYPE_COMPARE("ns", 2, _typename, _length, _typep); \
			break; \
		case 92: \
			RDATATYPE_COMPARE("md", 3, _typename, _length, _typep); \
			break; \
		case 58: \
			RDATATYPE_COMPARE("mf", 4, _typename, _length, _typep); \
			break; \
		case 8: \
			RDATATYPE_COMPARE("cname", 5, _typename, _length, _typep); \
			RDATATYPE_COMPARE("mx", 15, _typename, _length, _typep); \
			break; \
		case 182: \
			RDATATYPE_COMPARE("soa", 6, _typename, _length, _typep); \
			break; \
		case 126: \
			RDATATYPE_COMPARE("mb", 7, _typename, _length, _typep); \
			break; \
		case 169: \
			RDATATYPE_COMPARE("mg", 8, _typename, _length, _typep); \
			break; \
		case 110: \
			RDATATYPE_COMPARE("mr", 9, _typename, _length, _typep); \
			RDATATYPE_COMPARE("minfo", 14, _typename, _length, _typep); \
			break; \
		case 24: \
			RDATATYPE_COMPARE("null", 10, _typename, _length, _typep); \
			RDATATYPE_COMPARE("kx", 36, _typename, _length, _typep); \
			RDATATYPE_COMPARE("nsec3param", 51, _typename, _length, _typep); \
			break; \
		case 206: \
			RDATATYPE_COMPARE("wks", 11, _typename, _length, _typep); \
			break; \
		case 54: \
			RDATATYPE_COMPARE("ptr", 12, _typename, _length, _typep); \
			RDATATYPE_COMPARE("naptr", 35, _typename, _length, _typep); \
			break; \
		case 67: \
			RDATATYPE_COMPARE("hinfo", 13, _typename, _length, _typep); \
			break; \
		case 236: \
			RDATATYPE_COMPARE("txt", 16, _typename, _length, _typep); \
			break; \
		case 192: \
			RDATATYPE_COMPARE("rp", 17, _typename, _length, _typep); \
			break; \
		case 12: \
			RDATATYPE_COMPARE("afsdb", 18, _typename, _length, _typep); \
			break; \
		case 119: \
			RDATATYPE_COMPARE("x25", 19, _typename, _length, _typep); \
			break; \
		case 214: \
			RDATATYPE_COMPARE("isdn", 20, _typename, _length, _typep); \
			break; \
		case 144: \
			RDATATYPE_COMPARE("rt", 21, _typename, _length, _typep); \
			break; \
		case 224: \
			RDATATYPE_COMPARE("nsap", 22, _typename, _length, _typep); \
			RDATATYPE_COMPARE("uid", 101, _typename, _length, _typep); \
			break; \
		case 140: \
			RDATATYPE_COMPARE("nsap-ptr", 23, _typename, _length, _typep); \
			break; \
		case 122: \
			RDATATYPE_COMPARE("sig", 24, _typename, _length, _typep); \
			RDATATYPE_COMPARE("dlv", 32769, _typename, _length, _typep); \
			break; \
		case 254: \
			RDATATYPE_COMPARE("key", 25, _typename, _length, _typep); \
			break; \
		case 112: \
			RDATATYPE_COMPARE("px", 26, _typename, _length, _typep); \
			break; \
		case 17: \
			RDATATYPE_COMPARE("gpos", 27, _typename, _length, _typep); \
			break; \
		case 69: \
			RDATATYPE_COMPARE("aaaa", 28, _typename, _length, _typep); \
			RDATATYPE_COMPARE("atma", 34, _typename, _length, _typep); \
			break; \
		case 237: \
			RDATATYPE_COMPARE("loc", 29, _typename, _length, _typep); \
			break; \
		case 52: \
			RDATATYPE_COMPARE("nxt", 30, _typename, _length, _typep); \
			break; \
		case 160: \
			RDATATYPE_COMPARE("eid", 31, _typename, _length, _typep); \
			break; \
		case 220: \
			RDATATYPE_COMPARE("nimloc", 32, _typename, _length, _typep); \
			break; \
		case 100: \
			RDATATYPE_COMPARE("srv", 33, _typename, _length, _typep); \
			break; \
		case 172: \
			RDATATYPE_COMPARE("cert", 37, _typename, _length, _typep); \
			break; \
		case 226: \
			RDATATYPE_COMPARE("a6", 38, _typename, _length, _typep); \
			break; \
		case 109: \
			RDATATYPE_COMPARE("dname", 39, _typename, _length, _typep); \
			break; \
		case 168: \
			RDATATYPE_COMPARE("opt", 41, _typename, _length, _typep); \
			break; \
		case 48: \
			RDATATYPE_COMPARE("apl", 42, _typename, _length, _typep); \
			break; \
		case 210: \
			RDATATYPE_COMPARE("ds", 43, _typename, _length, _typep); \
			break; \
		case 128: \
			RDATATYPE_COMPARE("sshfp", 44, _typename, _length, _typep); \
			break; \
		case 105: \
			RDATATYPE_COMPARE("ipseckey", 45, _typename, _length, _typep); \
			break; \
		case 225: \
			RDATATYPE_COMPARE("rrsig", 46, _typename, _length, _typep); \
			break; \
		case 22: \
			RDATATYPE_COMPARE("nsec", 47, _typename, _length, _typep); \
			break; \
		case 26: \
			RDATATYPE_COMPARE("dnskey", 48, _typename, _length, _typep); \
			break; \
		case 4: \
			RDATATYPE_COMPARE("dhcid", 49, _typename, _length, _typep); \
			RDATATYPE_COMPARE("spf", 99, _typename, _length, _typep); \
			break; \
		case 233: \
			RDATATYPE_COMPARE("nsec3", 50, _typename, _length, _typep); \
			break; \
		case 230: \
			RDATATYPE_COMPARE("uinfo", 100, _typename, _length, _typep); \
			break; \
		case 104: \
			RDATATYPE_COMPARE("gid", 102, _typename, _length, _typep); \
			break; \
		case 145: \
			RDATATYPE_COMPARE("unspec", 103, _typename, _length, _typep); \
			break; \
		case 184: \
			RDATATYPE_COMPARE("tkey", 249, _typename, _length, _typep); \
			break; \
		case 72: \
			RDATATYPE_COMPARE("tsig", 250, _typename, _length, _typep); \
			break; \
		case 138: \
			RDATATYPE_COMPARE("ixfr", 251, _typename, _length, _typep); \
			break; \
		case 250: \
			RDATATYPE_COMPARE("axfr", 252, _typename, _length, _typep); \
			break; \
		case 164: \
			RDATATYPE_COMPARE("mailb", 253, _typename, _length, _typep); \
			break; \
		case 50: \
			RDATATYPE_COMPARE("maila", 254, _typename, _length, _typep); \
			break; \
		case 68: \
			RDATATYPE_COMPARE("any", 255, _typename, _length, _typep); \
			break; \
	}
#define RDATATYPE_ATTRIBUTE_SW \
	switch (type) { \
	case 0: return (DNS_RDATATYPEATTR_RESERVED); \
	case 1: return (RRTYPE_A_ATTRIBUTES); \
	case 2: return (RRTYPE_NS_ATTRIBUTES); \
	case 3: return (RRTYPE_MD_ATTRIBUTES); \
	case 4: return (RRTYPE_MF_ATTRIBUTES); \
	case 5: return (RRTYPE_CNAME_ATTRIBUTES); \
	case 6: return (RRTYPE_SOA_ATTRIBUTES); \
	case 7: return (RRTYPE_MB_ATTRIBUTES); \
	case 8: return (RRTYPE_MG_ATTRIBUTES); \
	case 9: return (RRTYPE_MR_ATTRIBUTES); \
	case 10: return (RRTYPE_NULL_ATTRIBUTES); \
	case 11: return (RRTYPE_WKS_ATTRIBUTES); \
	case 12: return (RRTYPE_PTR_ATTRIBUTES); \
	case 13: return (RRTYPE_HINFO_ATTRIBUTES); \
	case 14: return (RRTYPE_MINFO_ATTRIBUTES); \
	case 15: return (RRTYPE_MX_ATTRIBUTES); \
	case 16: return (RRTYPE_TXT_ATTRIBUTES); \
	case 17: return (RRTYPE_RP_ATTRIBUTES); \
	case 18: return (RRTYPE_AFSDB_ATTRIBUTES); \
	case 19: return (RRTYPE_X25_ATTRIBUTES); \
	case 20: return (RRTYPE_ISDN_ATTRIBUTES); \
	case 21: return (RRTYPE_RT_ATTRIBUTES); \
	case 22: return (RRTYPE_NSAP_ATTRIBUTES); \
	case 23: return (RRTYPE_NSAP_PTR_ATTRIBUTES); \
	case 24: return (RRTYPE_SIG_ATTRIBUTES); \
	case 25: return (RRTYPE_KEY_ATTRIBUTES); \
	case 26: return (RRTYPE_PX_ATTRIBUTES); \
	case 27: return (RRTYPE_GPOS_ATTRIBUTES); \
	case 28: return (RRTYPE_AAAA_ATTRIBUTES); \
	case 29: return (RRTYPE_LOC_ATTRIBUTES); \
	case 30: return (RRTYPE_NXT_ATTRIBUTES); \
	case 31: return (DNS_RDATATYPEATTR_RESERVED); \
	case 32: return (DNS_RDATATYPEATTR_RESERVED); \
	case 33: return (RRTYPE_SRV_ATTRIBUTES); \
	case 34: return (DNS_RDATATYPEATTR_RESERVED); \
	case 35: return (RRTYPE_NAPTR_ATTRIBUTES); \
	case 36: return (RRTYPE_KX_ATTRIBUTES); \
	case 37: return (RRTYPE_CERT_ATTRIBUTES); \
	case 38: return (RRTYPE_A6_ATTRIBUTES); \
	case 39: return (RRTYPE_DNAME_ATTRIBUTES); \
	case 41: return (RRTYPE_OPT_ATTRIBUTES); \
	case 42: return (RRTYPE_APL_ATTRIBUTES); \
	case 43: return (RRTYPE_DS_ATTRIBUTES); \
	case 44: return (RRTYPE_SSHFP_ATTRIBUTES); \
	case 45: return (RRTYPE_IPSECKEY_ATTRIBUTES); \
	case 46: return (RRTYPE_RRSIG_ATTRIBUTES); \
	case 47: return (RRTYPE_NSEC_ATTRIBUTES); \
	case 48: return (RRTYPE_DNSKEY_ATTRIBUTES); \
	case 49: return (RRTYPE_DHCID_ATTRIBUTES); \
	case 50: return (RRTYPE_NSEC3_ATTRIBUTES); \
	case 51: return (RRTYPE_NSEC3PARAM_ATTRIBUTES); \
	case 99: return (RRTYPE_SPF_ATTRIBUTES); \
	case 100: return (DNS_RDATATYPEATTR_RESERVED); \
	case 101: return (DNS_RDATATYPEATTR_RESERVED); \
	case 102: return (DNS_RDATATYPEATTR_RESERVED); \
	case 103: return (RRTYPE_UNSPEC_ATTRIBUTES); \
	case 249: return (RRTYPE_TKEY_ATTRIBUTES); \
	case 250: return (RRTYPE_TSIG_ATTRIBUTES); \
	case 251: return (DNS_RDATATYPEATTR_META | DNS_RDATATYPEATTR_QUESTIONONLY); \
	case 252: return (DNS_RDATATYPEATTR_META | DNS_RDATATYPEATTR_QUESTIONONLY); \
	case 253: return (DNS_RDATATYPEATTR_META | DNS_RDATATYPEATTR_QUESTIONONLY); \
	case 254: return (DNS_RDATATYPEATTR_META | DNS_RDATATYPEATTR_QUESTIONONLY); \
	case 255: return (DNS_RDATATYPEATTR_META | DNS_RDATATYPEATTR_QUESTIONONLY); \
	case 32769: return (RRTYPE_DLV_ATTRIBUTES); \
	}
#define RDATATYPE_TOTEXT_SW \
	switch (type) { \
	case 0: return (str_totext("RESERVED0", target)); \
	case 1: return (str_totext("A", target)); \
	case 2: return (str_totext("NS", target)); \
	case 3: return (str_totext("MD", target)); \
	case 4: return (str_totext("MF", target)); \
	case 5: return (str_totext("CNAME", target)); \
	case 6: return (str_totext("SOA", target)); \
	case 7: return (str_totext("MB", target)); \
	case 8: return (str_totext("MG", target)); \
	case 9: return (str_totext("MR", target)); \
	case 10: return (str_totext("NULL", target)); \
	case 11: return (str_totext("WKS", target)); \
	case 12: return (str_totext("PTR", target)); \
	case 13: return (str_totext("HINFO", target)); \
	case 14: return (str_totext("MINFO", target)); \
	case 15: return (str_totext("MX", target)); \
	case 16: return (str_totext("TXT", target)); \
	case 17: return (str_totext("RP", target)); \
	case 18: return (str_totext("AFSDB", target)); \
	case 19: return (str_totext("X25", target)); \
	case 20: return (str_totext("ISDN", target)); \
	case 21: return (str_totext("RT", target)); \
	case 22: return (str_totext("NSAP", target)); \
	case 23: return (str_totext("NSAP-PTR", target)); \
	case 24: return (str_totext("SIG", target)); \
	case 25: return (str_totext("KEY", target)); \
	case 26: return (str_totext("PX", target)); \
	case 27: return (str_totext("GPOS", target)); \
	case 28: return (str_totext("AAAA", target)); \
	case 29: return (str_totext("LOC", target)); \
	case 30: return (str_totext("NXT", target)); \
	case 31: return (str_totext("EID", target)); \
	case 32: return (str_totext("NIMLOC", target)); \
	case 33: return (str_totext("SRV", target)); \
	case 34: return (str_totext("ATMA", target)); \
	case 35: return (str_totext("NAPTR", target)); \
	case 36: return (str_totext("KX", target)); \
	case 37: return (str_totext("CERT", target)); \
	case 38: return (str_totext("A6", target)); \
	case 39: return (str_totext("DNAME", target)); \
	case 41: return (str_totext("OPT", target)); \
	case 42: return (str_totext("APL", target)); \
	case 43: return (str_totext("DS", target)); \
	case 44: return (str_totext("SSHFP", target)); \
	case 45: return (str_totext("IPSECKEY", target)); \
	case 46: return (str_totext("RRSIG", target)); \
	case 47: return (str_totext("NSEC", target)); \
	case 48: return (str_totext("DNSKEY", target)); \
	case 49: return (str_totext("DHCID", target)); \
	case 50: return (str_totext("NSEC3", target)); \
	case 51: return (str_totext("NSEC3PARAM", target)); \
	case 99: return (str_totext("SPF", target)); \
	case 100: return (str_totext("UINFO", target)); \
	case 101: return (str_totext("UID", target)); \
	case 102: return (str_totext("GID", target)); \
	case 103: return (str_totext("UNSPEC", target)); \
	case 249: return (str_totext("TKEY", target)); \
	case 250: return (str_totext("TSIG", target)); \
	case 251: return (str_totext("IXFR", target)); \
	case 252: return (str_totext("AXFR", target)); \
	case 253: return (str_totext("MAILB", target)); \
	case 254: return (str_totext("MAILA", target)); \
	case 255: return (str_totext("ANY", target)); \
	case 32769: return (str_totext("DLV", target)); \
	}
#endif /* DNS_CODE_H */
