.\" Copyright (c) 1996,1998-2005, 2007-2010
.\" 	Todd C. Miller <Todd.Miller@courtesan.com>
.\" 
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
.\" WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
.\" ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
.\" WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
.\" ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\" 
.\" Sponsored in part by the Defense Advanced Research Projects
.\" Agency (DARPA) and Air Force Research Laboratory, Air Force
.\" Materiel Command, USAF, under agreement number F39502-99-1-0512.
.\" 
.\" Automatically generated by Pod::Man 2.22 (Pod::Simple 3.07)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` 
.    ds C' 
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.ie \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.el \{\
.    de IX
..
.\}
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "VISUDO 8"
.TH VISUDO 8 "July 14, 2010" "1.7.4" "MAINTENANCE COMMANDS"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH "NAME"
visudo \- edit the sudoers file
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
\&\fBvisudo\fR [\fB\-c\fR] [\fB\-q\fR] [\fB\-s\fR] [\fB\-V\fR] [\fB\-f\fR \fIsudoers\fR]
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBvisudo\fR edits the \fIsudoers\fR file in a safe fashion, analogous to
\&\fIvipw\fR\|(8).  \fBvisudo\fR locks the \fIsudoers\fR file against multiple
simultaneous edits, provides basic sanity checks, and checks
for parse errors.  If the \fIsudoers\fR file is currently being
edited you will receive a message to try again later.
.PP
There is a hard-coded list of one or more editors that \fBvisudo\fR will
use set at compile-time that may be overridden via the \fIeditor\fR \fIsudoers\fR
\&\f(CW\*(C`Default\*(C'\fR variable.  This list defaults to \f(CW"/usr/bin/vi"\fR.  Normally,
\&\fBvisudo\fR does not honor the \f(CW\*(C`VISUAL\*(C'\fR or \f(CW\*(C`EDITOR\*(C'\fR environment
variables unless they contain an editor in the aforementioned editors
list.  However, if \fBvisudo\fR is configured with the \fI\-\-with\-env\-editor\fR
option or the \fIenv_editor\fR \f(CW\*(C`Default\*(C'\fR variable is set in \fIsudoers\fR,
\&\fBvisudo\fR will use any the editor defines by \f(CW\*(C`VISUAL\*(C'\fR or \f(CW\*(C`EDITOR\*(C'\fR.
Note that this can be a security hole since it allows the user to
execute any program they wish simply by setting \f(CW\*(C`VISUAL\*(C'\fR or \f(CW\*(C`EDITOR\*(C'\fR.
.PP
\&\fBvisudo\fR parses the \fIsudoers\fR file after the edit and will
not save the changes if there is a syntax error.  Upon finding
an error, \fBvisudo\fR will print a message stating the line number(s)
where the error occurred and the user will receive the
\&\*(L"What now?\*(R" prompt.  At this point the user may enter \*(L"e\*(R"
to re-edit the \fIsudoers\fR file, \*(L"x\*(R" to exit without
saving the changes, or \*(L"Q\*(R" to quit and save changes.  The
\&\*(L"Q\*(R" option should be used with extreme care because if \fBvisudo\fR
believes there to be a parse error, so will \fBsudo\fR and no one
will be able to \fBsudo\fR again until the error is fixed.
If \*(L"e\*(R" is typed to edit the  \fIsudoers\fR file after a parse error
has been detected, the cursor will be placed on the line where the
error occurred (if the editor supports this feature).
.SH "OPTIONS"
.IX Header "OPTIONS"
\&\fBvisudo\fR accepts the following command line options:
.IP "\-c" 12
.IX Item "-c"
Enable \fBcheck-only\fR mode.  The existing \fIsudoers\fR file will be
checked for syntax and a message will be printed to the
standard output detailing the status of \fIsudoers\fR.
If the syntax check completes successfully, \fBvisudo\fR will
exit with a value of 0.  If a syntax error is encountered,
\&\fBvisudo\fR will exit with a value of 1.
.IP "\-f \fIsudoers\fR" 12
.IX Item "-f sudoers"
Specify and alternate \fIsudoers\fR file location.  With this option
\&\fBvisudo\fR will edit (or check) the \fIsudoers\fR file of your choice,
instead of the default, \fI/etc/sudoers\fR.  The lock file used
is the specified \fIsudoers\fR file with \*(L".tmp\*(R" appended to it.
.IP "\-q" 12
.IX Item "-q"
Enable \fBquiet\fR mode.  In this mode details about syntax errors
are not printed.  This option is only useful when combined with
the \fB\-c\fR option.
.IP "\-s" 12
.IX Item "-s"
Enable \fBstrict\fR checking of the \fIsudoers\fR file.  If an alias is
used before it is defined, \fBvisudo\fR will consider this a parse
error.  Note that it is not possible to differentiate between an
alias and a host name or user name that consists solely of uppercase
letters, digits, and the underscore ('_') character.
.IP "\-V" 12
.IX Item "-V"
The \fB\-V\fR (version) option causes \fBvisudo\fR to print its version number
and exit.
.SH "ENVIRONMENT"
.IX Header "ENVIRONMENT"
The following environment variables may be consulted depending on
the value of the \fIeditor\fR and \fIenv_editor\fR \fIsudoers\fR variables:
.ie n .IP "\*(C`VISUAL\*(C'" 16
.el .IP "\f(CW\*(C`VISUAL\*(C'\fR" 16
.IX Item "VISUAL"
Invoked by visudo as the editor to use
.ie n .IP "\*(C`EDITOR\*(C'" 16
.el .IP "\f(CW\*(C`EDITOR\*(C'\fR" 16
.IX Item "EDITOR"
Used by visudo if \s-1VISUAL\s0 is not set
.SH "FILES"
.IX Header "FILES"
.ie n .IP "\fI/etc/sudoers\fR" 24
.el .IP "\fI/etc/sudoers\fR" 24
.IX Item "/etc/sudoers"
List of who can run what
.ie n .IP "\fI/etc/sudoers.tmp\fR" 24
.el .IP "\fI/etc/sudoers.tmp\fR" 24
.IX Item "/etc/sudoers.tmp"
Lock file for visudo
.SH "DIAGNOSTICS"
.IX Header "DIAGNOSTICS"
.IP "sudoers file busy, try again later." 4
.IX Item "sudoers file busy, try again later."
Someone else is currently editing the \fIsudoers\fR file.
.ie n .IP "/etc/sudoers.tmp: Permission denied" 4
.el .IP "\f(CW@sysconfdir\fR@/sudoers.tmp: Permission denied" 4
.IX Item "/etc/sudoers.tmp: Permission denied"
You didn't run \fBvisudo\fR as root.
.IP "Can't find you in the passwd database" 4
.IX Item "Can't find you in the passwd database"
Your userid does not appear in the system passwd file.
.IP "Warning: {User,Runas,Host,Cmnd}_Alias referenced but not defined" 4
.IX Item "Warning: {User,Runas,Host,Cmnd}_Alias referenced but not defined"
Either you are trying to use an undeclare {User,Runas,Host,Cmnd}_Alias
or you have a user or host name listed that consists solely of
uppercase letters, digits, and the underscore ('_') character.  In
the latter case, you can ignore the warnings (\fBsudo\fR will not
complain).  In \fB\-s\fR (strict) mode these are errors, not warnings.
.IP "Warning: unused {User,Runas,Host,Cmnd}_Alias" 4
.IX Item "Warning: unused {User,Runas,Host,Cmnd}_Alias"
The specified {User,Runas,Host,Cmnd}_Alias was defined but never
used.  You may wish to comment out or remove the unused alias.  In
\&\fB\-s\fR (strict) mode this is an error, not a warning.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fIvi\fR\|(1), \fIsudoers\fR\|(5), \fIsudo\fR\|(8), \fIvipw\fR\|(8)
.SH "AUTHOR"
.IX Header "AUTHOR"
Many people have worked on \fIsudo\fR over the years; this version of
\&\fBvisudo\fR was written by:
.PP
.Vb 1
\& Todd Miller
.Ve
.PP
See the \s-1HISTORY\s0 file in the sudo distribution or visit
http://www.sudo.ws/sudo/history.html for more details.
.SH "CAVEATS"
.IX Header "CAVEATS"
There is no easy way to prevent a user from gaining a root shell if 
the editor used by \fBvisudo\fR allows shell escapes.
.SH "BUGS"
.IX Header "BUGS"
If you feel you have found a bug in \fBvisudo\fR, please submit a bug report
at http://www.sudo.ws/sudo/bugs/
.SH "SUPPORT"
.IX Header "SUPPORT"
Limited free support is available via the sudo-users mailing list,
see http://www.sudo.ws/mailman/listinfo/sudo\-users to subscribe or
search the archives.
.SH "DISCLAIMER"
.IX Header "DISCLAIMER"
\&\fBvisudo\fR is provided ``\s-1AS\s0 \s-1IS\s0'' and any express or implied warranties,
including, but not limited to, the implied warranties of merchantability
and fitness for a particular purpose are disclaimed.  See the \s-1LICENSE\s0
file distributed with \fBsudo\fR or http://www.sudo.ws/sudo/license.html
for complete details.
