.\" Copyright (c) 2009-2010 Todd C. Miller <Todd.Miller@courtesan.com>
.\" 
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
.\" WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
.\" ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
.\" WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
.\" ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\" 
.\" Automatically generated by Pod::Man 2.22 (Pod::Simple 3.07)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` 
.    ds C' 
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.ie \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.el \{\
.    de IX
..
.\}
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "SUDOREPLAY 8"
.TH SUDOREPLAY 8 "July 12, 2010" "1.7.4" "MAINTENANCE COMMANDS"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH "NAME"
sudoreplay \- replay sudo session logs
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
\&\fBsudoreplay\fR [\fB\-d\fR \fIdirectory\fR] [\fB\-f\fR \fIfilter\fR] [\fB\-m\fR \fImax_wait\fR] [\fB\-s\fR \fIspeed_factor\fR] \s-1ID\s0
.PP
\&\fBsudoreplay\fR [\fB\-d\fR \fIdirectory\fR] \-l [search expression]
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBsudoreplay\fR plays back or lists the session logs created by
\&\fBsudo\fR.  When replaying, \fBsudoreplay\fR can play the session back
in real-time, or the playback speed may be adjusted (faster or
slower) based on the command line options.  The \fI\s-1ID\s0\fR should be
a six character sequence of digits and upper case letters, e.g.
0100A5, which is logged by \fBsudo\fR when a command is run with
session logging enabled.
.PP
In list mode, \fBsudoreplay\fR can be used to find the \s-1ID\s0 of a session
based on a number of criteria such as the user, tty or command run.
.PP
In replay mode, if the standard output has not been redirected,
\&\fBsudoreplay\fR will act on the following keys:
.IP "' ' (space)" 8
.IX Item "' ' (space)"
Pause output; press any key to resume.
.IP "'<'" 8
Reduce the playback speed by one half.
.IP "'>'" 8
Double the playback speed.
.SH "OPTIONS"
.IX Header "OPTIONS"
\&\fBsudoreplay\fR accepts the following command line options:
.IP "\-d \fIdirectory\fR" 12
.IX Item "-d directory"
Use \fIdirectory\fR to for the session logs instead of the default,
\&\fI/var/log/sudo\-io\fR.
.IP "\-f \fIfilter\fR" 12
.IX Item "-f filter"
By default, \fBsudoreplay\fR will play back the command's standard
output, standard error and tty output.  The \fI\-f\fR option can be
used to select which of these to output.  The \fIfilter\fR argument
is a comma-separated list, consisting of one or more of following:
\&\fIstdout\fR, \fIstderr\fR, and \fIttyout\fR.
.IP "\-l" 12
.IX Item "-l"
Enable \*(L"list mode\*(R".  In this mode, \fBsudoreplay\fR will list available
session IDs.  If a \fIsearch expression\fR is specified, it will be
used to restrict the IDs that are displayed.  An expression is
composed of the following predicates:
.RS 12
.IP "command \fIcommand pattern\fR" 8
.IX Item "command command pattern"
Evaluates to true if the command run matches \fIcommand pattern\fR.
On systems with \s-1POSIX\s0 regular expression support, the pattern may
be an extended regular expression.  On systems without \s-1POSIX\s0 regular
expression support, a simple substring match is performed instead.
.IP "cwd \fIdirectory\fR" 8
.IX Item "cwd directory"
Evaluates to true if the command was run with the specified current
working directory.
.IP "fromdate \fIdate\fR" 8
.IX Item "fromdate date"
Evaluates to true if the command was run on or after \fIdate\fR.
See \*(L"Date and time format\*(R" for a description of supported
date and time formats.
.IP "group \fIrunas_group\fR" 8
.IX Item "group runas_group"
Evaluates to true if the command was run with the specified
\&\fIrunas_group\fR.  Note that unless a \fIrunas_group\fR was explicitly
specified when \fBsudo\fR was run this field will be empty in the log.
.IP "runas \fIrunas_user\fR" 8
.IX Item "runas runas_user"
Evaluates to true if the command was run as the specified \fIrunas_user\fR.
Note that \fBsudo\fR runs commands as user \fIroot\fR by default.
.IP "todate \fIdate\fR" 8
.IX Item "todate date"
Evaluates to true if the command was run on or prior to \fIdate\fR.
See \*(L"Date and time format\*(R" for a description of supported
date and time formats.
.IP "tty \fItty\fR" 8
.IX Item "tty tty"
Evaluates to true if the command was run on the specified terminal
device.  The \fItty\fR should be specified without the \fI/dev/\fR prefix,
e.g.  \fItty01\fR instead of \fI/dev/tty01\fR.
.IP "user \fIuser name\fR" 8
.IX Item "user user name"
Evaluates to true if the \s-1ID\s0 matches a command run by \fIuser name\fR.
.RE
.RS 12
.Sp
Predicates may be abbreviated to the shortest unique string (currently
all predicates may be shortened to a single character).
.Sp
Predicates may be combined using \fIand\fR, \fIor\fR and \fI!\fR operators
as well as \f(CW\*(Aq(\*(Aq\fR and \f(CW\*(Aq)\*(Aq\fR for grouping (note that parentheses
must generally be escaped from the shell).  The \fIand\fR operator is
optional, adjacent predicates have an implied \fIand\fR unless separated
by an \fIor\fR.
.RE
.IP "\-m \fImax_wait\fR" 12
.IX Item "-m max_wait"
Specify an upper bound on how long to wait between key presses or
output data.  By default, \fBsudo_replay\fR will accurately reproduce
the delays between key presses or program output.  However, this
can be tedious when the session includes long pauses.  When the
\&\fI\-m\fR option is specified, \fBsudoreplay\fR will limit these pauses
to at most \fImax_wait\fR seconds.  The value may be specified as a
floating point number, .e.g. \fI2.5\fR.
.IP "\-s \fIspeed_factor\fR" 12
.IX Item "-s speed_factor"
This option causes \fBsudoreplay\fR to adjust the number of seconds
it will wait between key presses or program output.  This can be
used to slow down or speed up the display.  For example, a
\&\fIspeed_factor\fR of \fI2\fR would make the output twice as fast whereas
a \fIspeed_factor\fR of <.5> would make the output twice as slow.
.IP "\-V" 12
.IX Item "-V"
The \fB\-V\fR (version) option causes \fBsudoreplay\fR to print its version number
and exit.
.SS "Date and time format"
.IX Subsection "Date and time format"
The time and date may be specified multiple ways, common formats include:
.IP "\s-1HH:MM:SS\s0 am \s-1MM/DD/CCYY\s0 timezone" 8
.IX Item "HH:MM:SS am MM/DD/CCYY timezone"
24 hour time may be used in place of am/pm.
.IP "\s-1HH:MM:SS\s0 am Month, Day Year timezone" 8
.IX Item "HH:MM:SS am Month, Day Year timezone"
24 hour time may be used in place of am/pm, and month and day names
may be abbreviated.  Note that month and day of the week names must
be specified in English.
.IP "CCYY-MM-DD \s-1HH:MM:SS\s0" 8
.IX Item "CCYY-MM-DD HH:MM:SS"
\&\s-1ISO\s0 time format
.IP "\s-1DD\s0 Month \s-1CCYY\s0 \s-1HH:MM:SS\s0" 8
.IX Item "DD Month CCYY HH:MM:SS"
The month name may be abbreviated.
.PP
Either time or date may be omitted, the am/pm and timezone are
optional.  If no date is specified, the current day is assumed; if
no time is specified, the first second of the specified date is
used.  The less significant parts of both time and date may also
be omitted, in which case zero is assumed.  For example, the following
are all valid:
.PP
The following are all valid time and date specifications:
.IP "now" 8
.IX Item "now"
The current time and date.
.IP "tomorrow" 8
.IX Item "tomorrow"
Exactly one day from now.
.IP "yesterday" 8
.IX Item "yesterday"
24 hours ago.
.IP "2 hours ago" 8
.IX Item "2 hours ago"
2 hours ago.
.IP "next Friday" 8
.IX Item "next Friday"
The first second of the next Friday.
.IP "this week" 8
.IX Item "this week"
The current time but the first day of the coming week.
.IP "a fortnight ago" 8
.IX Item "a fortnight ago"
The current time but 14 days ago.
.IP "10:01 am 9/17/2009" 8
.IX Item "10:01 am 9/17/2009"
10:01 am, September 17, 2009.
.IP "10:01 am" 8
.IX Item "10:01 am"
10:01 am on the current day.
.IP "10" 8
.IX Item "10"
10:00 am on the current day.
.IP "9/17/2009" 8
.IX Item "9/17/2009"
00:00 am, September 17, 2009.
.IP "10:01 am Sep 17, 2009" 8
.IX Item "10:01 am Sep 17, 2009"
10:01 am, September 17, 2009.
.SH "FILES"
.IX Header "FILES"
.IP "\fI/var/log/sudo\-io\fR" 24
.IX Item "/var/log/sudo-io"
The default I/O log directory.
.IP "\fI/var/log/sudo\-io/00/00/01/log\fR" 24
.IX Item "/var/log/sudo-io/00/00/01/log"
Example session log info.
.IP "\fI/var/log/sudo\-io/00/00/01/stdin\fR" 24
.IX Item "/var/log/sudo-io/00/00/01/stdin"
Example session standard input log.
.IP "\fI/var/log/sudo\-io/00/00/01/stdout\fR" 24
.IX Item "/var/log/sudo-io/00/00/01/stdout"
Example session standard output log.
.IP "\fI/var/log/sudo\-io/00/00/01/stderr\fR" 24
.IX Item "/var/log/sudo-io/00/00/01/stderr"
Example session standard error log.
.IP "\fI/var/log/sudo\-io/00/00/01/ttyin\fR" 24
.IX Item "/var/log/sudo-io/00/00/01/ttyin"
Example session tty input file.
.IP "\fI/var/log/sudo\-io/00/00/01/ttyout\fR" 24
.IX Item "/var/log/sudo-io/00/00/01/ttyout"
Example session tty output file.
.IP "\fI/var/log/sudo\-io/00/00/01/timing\fR" 24
.IX Item "/var/log/sudo-io/00/00/01/timing"
Example session timing file.
.PP
Note that the \fIstdin\fR, \fIstdout\fR and \fIstderr\fR files will be empty
unless \fBsudo\fR was used as part of a pipeline for a particular
command.
.SH "EXAMPLES"
.IX Header "EXAMPLES"
List sessions run by user \fImillert\fR:
.PP
.Vb 1
\& sudoreplay \-l user millert
.Ve
.PP
List sessions run by user \fIbob\fR with a command containing the string vi:
.PP
.Vb 1
\& sudoreplay \-l user bob command vi
.Ve
.PP
List sessions run by user \fIjeff\fR that match a regular expression:
.PP
.Vb 1
\& sudoreplay \-l user jeff command \*(Aq/bin/[a\-z]*sh\*(Aq
.Ve
.PP
List sessions run by jeff or bob on the console:
.PP
.Vb 1
\& sudoreplay \-l ( user jeff or user bob ) tty console
.Ve
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fIsudo\fR\|(8), \fIscript\fR\|(1)
.SH "AUTHOR"
.IX Header "AUTHOR"
Todd C. Miller
.SH "BUGS"
.IX Header "BUGS"
If you feel you have found a bug in \fBsudoreplay\fR, please submit a bug report
at http://www.sudo.ws/sudo/bugs/
.SH "SUPPORT"
.IX Header "SUPPORT"
Limited free support is available via the sudo-users mailing list,
see http://www.sudo.ws/mailman/listinfo/sudo\-users to subscribe or
search the archives.
.SH "DISCLAIMER"
.IX Header "DISCLAIMER"
\&\fBsudoreplay\fR is provided ``\s-1AS\s0 \s-1IS\s0'' and any express or implied warranties,
including, but not limited to, the implied warranties of merchantability
and fitness for a particular purpose are disclaimed.  See the \s-1LICENSE\s0
file distributed with \fBsudo\fR or http://www.sudo.ws/sudo/license.html
for complete details.
