.\" Copyright (c) 1994-1996, 1998-2005, 2007-2010
.\" 	Todd C. Miller <Todd.Miller@courtesan.com>
.\" 
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
.\" WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
.\" ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
.\" WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
.\" ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\" 
.\" Sponsored in part by the Defense Advanced Research Projects
.\" Agency (DARPA) and Air Force Research Laboratory, Air Force
.\" Materiel Command, USAF, under agreement number F39502-99-1-0512.
.\" 
.nr SL 0
.nr BA 0
.nr LC 1
.\"
.\" Automatically generated by Pod::Man 2.23 (Pod::Simple 3.14)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` 
.    ds C' 
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.ie \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.el \{\
.    de IX
..
.\}
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "SUDOERS 5"
.TH SUDOERS 5 "January 12, 2011" "1.7.4" "MAINTENANCE COMMANDS"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH "NAME"
sudoers \- list of which users may execute what
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
The \fIsudoers\fR file is composed of two types of entries: aliases
(basically variables) and user specifications (which specify who
may run what).
.PP
When multiple entries match for a user, they are applied in order.
Where there are multiple matches, the last match is used (which is
not necessarily the most specific match).
.PP
The \fIsudoers\fR grammar will be described below in Extended Backus-Naur
Form (\s-1EBNF\s0).  Don't despair if you don't know what \s-1EBNF\s0 is; it is
fairly simple, and the definitions below are annotated.
.SS "Quick guide to \s-1EBNF\s0"
.IX Subsection "Quick guide to EBNF"
\&\s-1EBNF\s0 is a concise and exact way of describing the grammar of a language.
Each \s-1EBNF\s0 definition is made up of \fIproduction rules\fR.  E.g.,
.PP
.Vb 1
\& symbol ::= definition | alternate1 | alternate2 ...
.Ve
.PP
Each \fIproduction rule\fR references others and thus makes up a
grammar for the language.  \s-1EBNF\s0 also contains the following
operators, which many readers will recognize from regular
expressions.  Do not, however, confuse them with \*(L"wildcard\*(R"
characters, which have different meanings.
.ie n .IP "\*(C`?\*(C'" 4
.el .IP "\f(CW\*(C`?\*(C'\fR" 4
.IX Item "?"
Means that the preceding symbol (or group of symbols) is optional.
That is, it may appear once or not at all.
.ie n .IP "\*(C`*\*(C'" 4
.el .IP "\f(CW\*(C`*\*(C'\fR" 4
.IX Item "*"
Means that the preceding symbol (or group of symbols) may appear
zero or more times.
.ie n .IP "\*(C`+\*(C'" 4
.el .IP "\f(CW\*(C`+\*(C'\fR" 4
.IX Item "+"
Means that the preceding symbol (or group of symbols) may appear
one or more times.
.PP
Parentheses may be used to group symbols together.  For clarity,
we will use single quotes ('') to designate what is a verbatim character
string (as opposed to a symbol name).
.SS "Aliases"
.IX Subsection "Aliases"
There are four kinds of aliases: \f(CW\*(C`User_Alias\*(C'\fR, \f(CW\*(C`Runas_Alias\*(C'\fR,
\&\f(CW\*(C`Host_Alias\*(C'\fR and \f(CW\*(C`Cmnd_Alias\*(C'\fR.
.PP
.Vb 4
\& Alias ::= \*(AqUser_Alias\*(Aq  User_Alias (\*(Aq:\*(Aq User_Alias)* |
\&           \*(AqRunas_Alias\*(Aq Runas_Alias (\*(Aq:\*(Aq Runas_Alias)* |
\&           \*(AqHost_Alias\*(Aq  Host_Alias (\*(Aq:\*(Aq Host_Alias)* |
\&           \*(AqCmnd_Alias\*(Aq  Cmnd_Alias (\*(Aq:\*(Aq Cmnd_Alias)*
\&
\& User_Alias ::= NAME \*(Aq=\*(Aq User_List
\&
\& Runas_Alias ::= NAME \*(Aq=\*(Aq Runas_List
\&
\& Host_Alias ::= NAME \*(Aq=\*(Aq Host_List
\&
\& Cmnd_Alias ::= NAME \*(Aq=\*(Aq Cmnd_List
\&
\& NAME ::= [A\-Z]([A\-Z][0\-9]_)*
.Ve
.PP
Each \fIalias\fR definition is of the form
.PP
.Vb 1
\& Alias_Type NAME = item1, item2, ...
.Ve
.PP
where \fIAlias_Type\fR is one of \f(CW\*(C`User_Alias\*(C'\fR, \f(CW\*(C`Runas_Alias\*(C'\fR, \f(CW\*(C`Host_Alias\*(C'\fR,
or \f(CW\*(C`Cmnd_Alias\*(C'\fR.  A \f(CW\*(C`NAME\*(C'\fR is a string of uppercase letters, numbers,
and underscore characters ('_').  A \f(CW\*(C`NAME\*(C'\fR \fBmust\fR start with an
uppercase letter.  It is possible to put several alias definitions
of the same type on a single line, joined by a colon (':').  E.g.,
.PP
.Vb 1
\& Alias_Type NAME = item1, item2, item3 : NAME = item4, item5
.Ve
.PP
The definitions of what constitutes a valid \fIalias\fR member follow.
.PP
.Vb 2
\& User_List ::= User |
\&               User \*(Aq,\*(Aq User_List
\&
\& User ::= \*(Aq!\*(Aq* user name |
\&          \*(Aq!\*(Aq* \*(Aq#\*(Aquid |
\&          \*(Aq!\*(Aq* \*(Aq%\*(Aqgroup |
\&          \*(Aq!\*(Aq* \*(Aq+\*(Aqnetgroup |
\&          \*(Aq!\*(Aq* \*(Aq%:\*(Aqnonunix_group |
\&          \*(Aq!\*(Aq* User_Alias
.Ve
.PP
A \f(CW\*(C`User_List\*(C'\fR is made up of one or more user names, uids (prefixed
with '#'), system groups (prefixed with '%'), netgroups (prefixed
with '+') and \f(CW\*(C`User_Alias\*(C'\fRes.  Each list item may be prefixed with
zero or more '!' operators.  An odd number of '!' operators negate
the value of the item; an even number just cancel each other out.
.PP
A \f(CW\*(C`user name\*(C'\fR, \f(CW\*(C`group\*(C'\fR, \f(CW\*(C`netgroup\*(C'\fR or \f(CW\*(C`nonunix_group\*(C'\fR may
be enclosed in double quotes to avoid the need for escaping special
characters.  Alternately, special characters may be specified in
escaped hex mode, e.g. \ex20 for space.
.PP
The \f(CW\*(C`nonunix_group\*(C'\fR syntax depends on the underlying implementation.
For instance, the \s-1QAS\s0 \s-1AD\s0 backend supports the following formats:
.IP "\(bu" 4
Group in the same domain: \*(L"Group Name\*(R"
.IP "\(bu" 4
Group in any domain: \*(L"Group Name@FULLY.QUALIFIED.DOMAIN\*(R"
.IP "\(bu" 4
Group \s-1SID:\s0 \*(L"S\-1\-2\-34\-5678901234\-5678901234\-5678901234\-567\*(R"
.PP
Note that quotes around group names are optional.  Unquoted strings must
use a backslash (\e) to escape spaces and the '@' symbol.
.PP
.Vb 2
\& Runas_List ::= Runas_Member |
\&                Runas_Member \*(Aq,\*(Aq Runas_List
\&
\& Runas_Member ::= \*(Aq!\*(Aq* user name |
\&                  \*(Aq!\*(Aq* \*(Aq#\*(Aquid |
\&                  \*(Aq!\*(Aq* \*(Aq%\*(Aqgroup |
\&                  \*(Aq!\*(Aq* +netgroup |
\&                  \*(Aq!\*(Aq* Runas_Alias
.Ve
.PP
A \f(CW\*(C`Runas_List\*(C'\fR is similar to a \f(CW\*(C`User_List\*(C'\fR except that instead
of \f(CW\*(C`User_Alias\*(C'\fRes it can contain \f(CW\*(C`Runas_Alias\*(C'\fRes.  Note that
user names and groups are matched as strings.  In other words, two
users (groups) with the same uid (gid) are considered to be distinct.
If you wish to match all user names with the same uid (e.g.\ root
and toor), you can use a uid instead (#0 in the example given).
.PP
.Vb 2
\& Host_List ::= Host |
\&               Host \*(Aq,\*(Aq Host_List
\&
\& Host ::= \*(Aq!\*(Aq* host name |
\&          \*(Aq!\*(Aq* ip_addr |
\&          \*(Aq!\*(Aq* network(/netmask)? |
\&          \*(Aq!\*(Aq* \*(Aq+\*(Aqnetgroup |
\&          \*(Aq!\*(Aq* Host_Alias
.Ve
.PP
A \f(CW\*(C`Host_List\*(C'\fR is made up of one or more host names, \s-1IP\s0 addresses,
network numbers, netgroups (prefixed with '+') and other aliases.
Again, the value of an item may be negated with the '!' operator.
If you do not specify a netmask along with the network number,
\&\fBsudo\fR will query each of the local host's network interfaces and,
if the network number corresponds to one of the hosts's network
interfaces, the corresponding netmask will be used.  The netmask
may be specified either in standard \s-1IP\s0 address notation
(e.g.\ 255.255.255.0 or ffff:ffff:ffff:ffff::),
or \s-1CIDR\s0 notation (number of bits, e.g.\ 24 or 64).  A host name may
include shell-style wildcards (see the Wildcards section below),
but unless the \f(CW\*(C`host name\*(C'\fR command on your machine returns the fully
qualified host name, you'll need to use the \fIfqdn\fR option for
wildcards to be useful.  Note \fBsudo\fR only inspects actual network
interfaces; this means that \s-1IP\s0 address 127.0.0.1 (localhost) will
never match.  Also, the host name \*(L"localhost\*(R" will only match if
that is the actual host name, which is usually only the case for
non-networked systems.
.PP
.Vb 2
\& Cmnd_List ::= Cmnd |
\&               Cmnd \*(Aq,\*(Aq Cmnd_List
\&
\& commandname ::= file name |
\&                 file name args |
\&                 file name \*(Aq""\*(Aq
\&
\& Cmnd ::= \*(Aq!\*(Aq* commandname |
\&          \*(Aq!\*(Aq* directory |
\&          \*(Aq!\*(Aq* "sudoedit" |
\&          \*(Aq!\*(Aq* Cmnd_Alias
.Ve
.PP
A \f(CW\*(C`Cmnd_List\*(C'\fR is a list of one or more commandnames, directories, and other
aliases.  A commandname is a fully qualified file name which may include
shell-style wildcards (see the Wildcards section below).  A simple
file name allows the user to run the command with any arguments he/she
wishes.  However, you may also specify command line arguments (including
wildcards).  Alternately, you can specify \f(CW""\fR to indicate that the command
may only be run \fBwithout\fR command line arguments.  A directory is a
fully qualified path name ending in a '/'.  When you specify a directory
in a \f(CW\*(C`Cmnd_List\*(C'\fR, the user will be able to run any file within that directory
(but not in any subdirectories therein).
.PP
If a \f(CW\*(C`Cmnd\*(C'\fR has associated command line arguments, then the arguments
in the \f(CW\*(C`Cmnd\*(C'\fR must match exactly those given by the user on the command line
(or match the wildcards if there are any).  Note that the following
characters must be escaped with a '\e' if they are used in command
arguments: ',', ':', '=', '\e'.  The special command \f(CW"sudoedit"\fR
is used to permit a user to run \fBsudo\fR with the \fB\-e\fR option (or
as \fBsudoedit\fR).  It may take command line arguments just as
a normal command does.
.SS "Defaults"
.IX Subsection "Defaults"
Certain configuration options may be changed from their default
values at runtime via one or more \f(CW\*(C`Default_Entry\*(C'\fR lines.  These
may affect all users on any host, all users on a specific host, a
specific user, a specific command, or commands being run as a specific user.
Note that per-command entries may not include command line arguments.
If you need to specify arguments, define a \f(CW\*(C`Cmnd_Alias\*(C'\fR and reference
that instead.
.PP
.Vb 5
\& Default_Type ::= \*(AqDefaults\*(Aq |
\&                  \*(AqDefaults\*(Aq \*(Aq@\*(Aq Host_List |
\&                  \*(AqDefaults\*(Aq \*(Aq:\*(Aq User_List |
\&                  \*(AqDefaults\*(Aq \*(Aq!\*(Aq Cmnd_List |
\&                  \*(AqDefaults\*(Aq \*(Aq>\*(Aq Runas_List
\&
\& Default_Entry ::= Default_Type Parameter_List
\&
\& Parameter_List ::= Parameter |
\&                    Parameter \*(Aq,\*(Aq Parameter_List
\&
\& Parameter ::= Parameter \*(Aq=\*(Aq Value |
\&               Parameter \*(Aq+=\*(Aq Value |
\&               Parameter \*(Aq\-=\*(Aq Value |
\&               \*(Aq!\*(Aq* Parameter
.Ve
.PP
Parameters may be \fBflags\fR, \fBinteger\fR values, \fBstrings\fR, or \fBlists\fR.
Flags are implicitly boolean and can be turned off via the '!'
operator.  Some integer, string and list parameters may also be
used in a boolean context to disable them.  Values may be enclosed
in double quotes (\f(CW\*(C`"\*(C'\fR) when they contain multiple words.  Special
characters may be escaped with a backslash (\f(CW\*(C`\e\*(C'\fR).
.PP
Lists have two additional assignment operators, \f(CW\*(C`+=\*(C'\fR and \f(CW\*(C`\-=\*(C'\fR.
These operators are used to add to and delete from a list respectively.
It is not an error to use the \f(CW\*(C`\-=\*(C'\fR operator to remove an element
that does not exist in a list.
.PP
Defaults entries are parsed in the following order: generic, host
and user Defaults first, then runas Defaults and finally command
defaults.
.PP
See \*(L"\s-1SUDOERS\s0 \s-1OPTIONS\s0\*(R" for a list of supported Defaults parameters.
.SS "User Specification"
.IX Subsection "User Specification"
.Vb 2
\& User_Spec ::= User_List Host_List \*(Aq=\*(Aq Cmnd_Spec_List \e
\&               (\*(Aq:\*(Aq Host_List \*(Aq=\*(Aq Cmnd_Spec_List)*
\&
\& Cmnd_Spec_List ::= Cmnd_Spec |
\&                    Cmnd_Spec \*(Aq,\*(Aq Cmnd_Spec_List
\&
.ie \n(SL \& Cmnd_Spec ::= Runas_Spec? SELinux_Spec? Tag_Spec* Cmnd
.el \& Cmnd_Spec ::= Runas_Spec? Tag_Spec* Cmnd
\&
\& Runas_Spec ::= \*(Aq(\*(Aq Runas_List? (\*(Aq:\*(Aq Runas_List)? \*(Aq)\*(Aq
\&
.if \n(SL \{\
\& SELinux_Spec ::= (\*(AqROLE=role\*(Aq | \*(AqTYPE=type\*(Aq)
\&
\}
\& Tag_Spec ::= (\*(AqNOPASSWD:\*(Aq | \*(AqPASSWD:\*(Aq | \*(AqNOEXEC:\*(Aq | \*(AqEXEC:\*(Aq |
\&               \*(AqSETENV:\*(Aq | \*(AqNOSETENV:\*(Aq | \*(AqLOG_INPUT:\*(Aq | \*(AqNOLOG_INPUT:\*(Aq |
\&               \*(AqLOG_OUTPUT:\*(Aq | \*(AqNOLOG_OUTPUT:\*(Aq)
.Ve
.PP
A \fBuser specification\fR determines which commands a user may run
(and as what user) on specified hosts.  By default, commands are
run as \fBroot\fR, but this can be changed on a per-command basis.
.PP
The basic structure of a user specification is `who = where (as_whom)
what'.  Let's break that down into its constituent parts:
.SS "Runas_Spec"
.IX Subsection "Runas_Spec"
A \f(CW\*(C`Runas_Spec\*(C'\fR determines the user and/or the group that a command
may be run as.  A fully-specified \f(CW\*(C`Runas_Spec\*(C'\fR consists of two
\&\f(CW\*(C`Runas_List\*(C'\fRs (as defined above) separated by a colon (':') and
enclosed in a set of parentheses.  The first \f(CW\*(C`Runas_List\*(C'\fR indicates
which users the command may be run as via \fBsudo\fR's \fB\-u\fR option.
The second defines a list of groups that can be specified via
\&\fBsudo\fR's \fB\-g\fR option.  If both \f(CW\*(C`Runas_List\*(C'\fRs are specified, the
command may be run with any combination of users and groups listed
in their respective \f(CW\*(C`Runas_List\*(C'\fRs.  If only the first is specified,
the command may be run as any user in the list but no \fB\-g\fR option
may be specified.  If the first \f(CW\*(C`Runas_List\*(C'\fR is empty but the
second is specified, the command may be run as the invoking user
with the group set to any listed in the \f(CW\*(C`Runas_List\*(C'\fR.  If no
\&\f(CW\*(C`Runas_Spec\*(C'\fR is specified the command may be run as \fBroot\fR and
no group may be specified.
.PP
A \f(CW\*(C`Runas_Spec\*(C'\fR sets the default for the commands that follow it.
What this means is that for the entry:
.PP
.Vb 1
\& dgb    boulder = (operator) /bin/ls, /bin/kill, /usr/bin/lprm
.Ve
.PP
The user \fBdgb\fR may run \fI/bin/ls\fR, \fI/bin/kill\fR, and
\&\fI/usr/bin/lprm\fR \*(-- but only as \fBoperator\fR.  E.g.,
.PP
.Vb 1
\& $ sudo \-u operator /bin/ls.
.Ve
.PP
It is also possible to override a \f(CW\*(C`Runas_Spec\*(C'\fR later on in an
entry.  If we modify the entry like so:
.PP
.Vb 1
\& dgb    boulder = (operator) /bin/ls, (root) /bin/kill, /usr/bin/lprm
.Ve
.PP
Then user \fBdgb\fR is now allowed to run \fI/bin/ls\fR as \fBoperator\fR,
but  \fI/bin/kill\fR and \fI/usr/bin/lprm\fR as \fBroot\fR.
.PP
We can extend this to allow \fBdgb\fR to run \f(CW\*(C`/bin/ls\*(C'\fR with either
the user or group set to \fBoperator\fR:
.PP
.Vb 2
\& dgb    boulder = (operator : operator) /bin/ls, (root) /bin/kill, \e
\&        /usr/bin/lprm
.Ve
.PP
In the following example, user \fBtcm\fR may run commands that access
a modem device file with the dialer group.  Note that in this example
only the group will be set, the command still runs as user \fBtcm\fR.
.PP
.Vb 2
\& tcm    boulder = (:dialer) /usr/bin/tip, /usr/bin/cu, \e
\&        /usr/local/bin/minicom
.Ve
.if \n(SL \{\
.SS "SELinux_Spec"
.IX Subsection "SELinux_Spec"
On systems with SELinux support, \fIsudoers\fR entries may optionally have
an SELinux role and/or type associated with a command.  If a role or
type is specified with the command it will override any default values
specified in \fIsudoers\fR.  A role or type specified on the command line,
however, will supercede the values in \fIsudoers\fR.
\}
.SS "Tag_Spec"
.IX Subsection "Tag_Spec"
A command may have zero or more tags associated with it.  There are
eight possible tag values, \f(CW\*(C`NOPASSWD\*(C'\fR, \f(CW\*(C`PASSWD\*(C'\fR, \f(CW\*(C`NOEXEC\*(C'\fR,
\&\f(CW\*(C`EXEC\*(C'\fR, \f(CW\*(C`SETENV\*(C'\fR, \f(CW\*(C`NOSETENV\*(C'\fR, \f(CW\*(C`LOG_INPUT\*(C'\fR, \f(CW\*(C`NOLOG_INPUT\*(C'\fR,
\&\f(CW\*(C`LOG_OUTPUT\*(C'\fR and \f(CW\*(C`NOLOG_OUTPUT\*(C'\fR.  Once a tag is set on a \f(CW\*(C`Cmnd\*(C'\fR,
subsequent \f(CW\*(C`Cmnd\*(C'\fRs in the \f(CW\*(C`Cmnd_Spec_List\*(C'\fR, inherit the tag unless
it is overridden by the opposite tag (i.e.: \f(CW\*(C`PASSWD\*(C'\fR overrides
\&\f(CW\*(C`NOPASSWD\*(C'\fR and \f(CW\*(C`NOEXEC\*(C'\fR overrides \f(CW\*(C`EXEC\*(C'\fR).
.PP
\fI\s-1NOPASSWD\s0 and \s-1PASSWD\s0\fR
.IX Subsection "NOPASSWD and PASSWD"
.PP
By default, \fBsudo\fR requires that a user authenticate him or herself
before running a command.  This behavior can be modified via the
\&\f(CW\*(C`NOPASSWD\*(C'\fR tag.  Like a \f(CW\*(C`Runas_Spec\*(C'\fR, the \f(CW\*(C`NOPASSWD\*(C'\fR tag sets
a default for the commands that follow it in the \f(CW\*(C`Cmnd_Spec_List\*(C'\fR.
Conversely, the \f(CW\*(C`PASSWD\*(C'\fR tag can be used to reverse things.
For example:
.PP
.Vb 1
\& ray    rushmore = NOPASSWD: /bin/kill, /bin/ls, /usr/bin/lprm
.Ve
.PP
would allow the user \fBray\fR to run \fI/bin/kill\fR, \fI/bin/ls\fR, and
\&\fI/usr/bin/lprm\fR as \fBroot\fR on the machine rushmore without
authenticating himself.  If we only want \fBray\fR to be able to
run \fI/bin/kill\fR without a password the entry would be:
.PP
.Vb 1
\& ray    rushmore = NOPASSWD: /bin/kill, PASSWD: /bin/ls, /usr/bin/lprm
.Ve
.PP
Note, however, that the \f(CW\*(C`PASSWD\*(C'\fR tag has no effect on users who are
in the group specified by the \fIexempt_group\fR option.
.PP
By default, if the \f(CW\*(C`NOPASSWD\*(C'\fR tag is applied to any of the entries
for a user on the current host, he or she will be able to run
\&\f(CW\*(C`sudo \-l\*(C'\fR without a password.  Additionally, a user may only run
\&\f(CW\*(C`sudo \-v\*(C'\fR without a password if the \f(CW\*(C`NOPASSWD\*(C'\fR tag is present
for all a user's entries that pertain to the current host.
This behavior may be overridden via the verifypw and listpw options.
.PP
\fI\s-1NOEXEC\s0 and \s-1EXEC\s0\fR
.IX Subsection "NOEXEC and EXEC"
.PP
If \fBsudo\fR has been compiled with \fInoexec\fR support and the underlying
operating system supports it, the \f(CW\*(C`NOEXEC\*(C'\fR tag can be used to prevent
a dynamically-linked executable from running further commands itself.
.PP
In the following example, user \fBaaron\fR may run \fI/usr/bin/more\fR
and \fI/usr/bin/vi\fR but shell escapes will be disabled.
.PP
.Vb 1
\& aaron  shanty = NOEXEC: /usr/bin/more, /usr/bin/vi
.Ve
.PP
See the \*(L"\s-1PREVENTING\s0 \s-1SHELL\s0 \s-1ESCAPES\s0\*(R" section below for more details
on how \f(CW\*(C`NOEXEC\*(C'\fR works and whether or not it will work on your system.
.PP
\fI\s-1SETENV\s0 and \s-1NOSETENV\s0\fR
.IX Subsection "SETENV and NOSETENV"
.PP
These tags override the value of the \fIsetenv\fR option on a per-command
basis.  Note that if \f(CW\*(C`SETENV\*(C'\fR has been set for a command, any
environment variables set on the command line way are not subject
to the restrictions imposed by \fIenv_check\fR, \fIenv_delete\fR, or
\&\fIenv_keep\fR.  As such, only trusted users should be allowed to set
variables in this manner.  If the command matched is \fB\s-1ALL\s0\fR, the
\&\f(CW\*(C`SETENV\*(C'\fR tag is implied for that command; this default may
be overridden by use of the \f(CW\*(C`NOSETENV\*(C'\fR tag.
.PP
\fI\s-1LOG_INPUT\s0 and \s-1NOLOG_INPUT\s0\fR
.IX Subsection "LOG_INPUT and NOLOG_INPUT"
.PP
These tags override the value of the \fIlog_input\fR option on a
per-command basis.  For more information, see the description of
\&\fIlog_input\fR in the \*(L"\s-1SUDOERS\s0 \s-1OPTIONS\s0\*(R" section below.
.PP
\fI\s-1LOG_OUTPUT\s0 and \s-1NOLOG_OUTPUT\s0\fR
.IX Subsection "LOG_OUTPUT and NOLOG_OUTPUT"
.PP
These tags override the value of the \fIlog_output\fR option on a
per-command basis.  For more information, see the description of
\&\fIlog_output\fR in the \*(L"\s-1SUDOERS\s0 \s-1OPTIONS\s0\*(R" section below.
.SS "Wildcards"
.IX Subsection "Wildcards"
\&\fBsudo\fR allows shell-style \fIwildcards\fR (aka meta or glob characters)
to be used in host names, path names and command line arguments in
the \fIsudoers\fR file.  Wildcard matching is done via the \fB\s-1POSIX\s0\fR
\&\fIglob\fR\|(3) and \fIfnmatch\fR\|(3) routines.  Note that these are \fInot\fR
regular expressions.
.ie n .IP "\*(C`*\*(C'" 8
.el .IP "\f(CW\*(C`*\*(C'\fR" 8
.IX Item "*"
Matches any set of zero or more characters.
.ie n .IP "\*(C`?\*(C'" 8
.el .IP "\f(CW\*(C`?\*(C'\fR" 8
.IX Item "?"
Matches any single character.
.ie n .IP "\*(C`[...]\*(C'" 8
.el .IP "\f(CW\*(C`[...]\*(C'\fR" 8
.IX Item "[...]"
Matches any character in the specified range.
.ie n .IP "\*(C`[!...]\*(C'" 8
.el .IP "\f(CW\*(C`[!...]\*(C'\fR" 8
.IX Item "[!...]"
Matches any character \fBnot\fR in the specified range.
.ie n .IP "\*(C`\ex\*(C'" 8
.el .IP "\f(CW\*(C`\ex\*(C'\fR" 8
.IX Item "x"
For any character \*(L"x\*(R", evaluates to \*(L"x\*(R".  This is used to
escape special characters such as: \*(L"*\*(R", \*(L"?\*(R", \*(L"[\*(R", and \*(L"}\*(R".
.PP
\&\s-1POSIX\s0 character classes may also be used if your system's \fIglob\fR\|(3)
and \fIfnmatch\fR\|(3) functions support them.  However, because the
\&\f(CW\*(Aq:\*(Aq\fR character has special meaning in \fIsudoers\fR, it must be
escaped.  For example:
.PP
.Vb 1
\&    /bin/ls [[\e:alpha\e:]]*
.Ve
.PP
Would match any file name beginning with a letter.
.PP
Note that a forward slash ('/') will \fBnot\fR be matched by
wildcards used in the path name.  When matching the command
line arguments, however, a slash \fBdoes\fR get matched by
wildcards.  This is to make a path like:
.PP
.Vb 1
\&    /usr/bin/*
.Ve
.PP
match \fI/usr/bin/who\fR but not \fI/usr/bin/X11/xterm\fR.
.SS "Exceptions to wildcard rules"
.IX Subsection "Exceptions to wildcard rules"
The following exceptions apply to the above rules:
.ie n .IP """""" 8
.el .IP "\f(CW``''\fR" 8
.IX Item """"""
If the empty string \f(CW""\fR is the only command line argument in the
\&\fIsudoers\fR entry it means that command is not allowed to be run
with \fBany\fR arguments.
.SS "Including other files from within sudoers"
.IX Subsection "Including other files from within sudoers"
It is possible to include other \fIsudoers\fR files from within the
\&\fIsudoers\fR file currently being parsed using the \f(CW\*(C`#include\*(C'\fR and
\&\f(CW\*(C`#includedir\*(C'\fR directives.
.PP
This can be used, for example, to keep a site-wide \fIsudoers\fR file
in addition to a local, per-machine file.  For the sake of this
example the site-wide \fIsudoers\fR will be \fI/etc/sudoers\fR and the
per-machine one will be \fI/etc/sudoers.local\fR.  To include
\&\fI/etc/sudoers.local\fR from within \fI/etc/sudoers\fR we would use the
following line in \fI/etc/sudoers\fR:
.Sp
.RS 4
\&\f(CW\*(C`#include /etc/sudoers.local\*(C'\fR
.RE
.PP
When \fBsudo\fR reaches this line it will suspend processing of the
current file (\fI/etc/sudoers\fR) and switch to \fI/etc/sudoers.local\fR.
Upon reaching the end of \fI/etc/sudoers.local\fR, the rest of
\&\fI/etc/sudoers\fR will be processed.  Files that are included may
themselves include other files.  A hard limit of 128 nested include
files is enforced to prevent include file loops.
.PP
The file name may include the \f(CW%h\fR escape, signifying the short form
of the host name.  I.e., if the machine's host name is \*(L"xerxes\*(R", then
.PP
\&\f(CW\*(C`#include /etc/sudoers.%h\*(C'\fR
.PP
will cause \fBsudo\fR to include the file \fI/etc/sudoers.xerxes\fR.
.PP
The \f(CW\*(C`#includedir\*(C'\fR directive can be used to create a \fIsudo.d\fR
directory that the system package manager can drop \fIsudoers\fR rules
into as part of package installation.  For example, given:
.PP
\&\f(CW\*(C`#includedir /etc/sudoers.d\*(C'\fR
.PP
\&\fBsudo\fR will read each file in \fI/etc/sudoers.d\fR, skipping file
names that end in \f(CW\*(C`~\*(C'\fR or contain a \f(CW\*(C`.\*(C'\fR character to avoid causing
problems with package manager or editor temporary/backup files.
Files are parsed in sorted lexical order.  That is,
\&\fI/etc/sudoers.d/01_first\fR will be parsed before
\&\fI/etc/sudoers.d/10_second\fR.  Be aware that because the sorting is
lexical, not numeric, \fI/etc/sudoers.d/1_whoops\fR would be loaded
\&\fBafter\fR \fI/etc/sudoers.d/10_second\fR.  Using a consistent number
of leading zeroes in the file names can be used to avoid such
problems.
.PP
Note that unlike files included via \f(CW\*(C`#include\*(C'\fR, \fBvisudo\fR will not
edit the files in a \f(CW\*(C`#includedir\*(C'\fR directory unless one of them
contains a syntax error.  It is still possible to run \fBvisudo\fR
with the \f(CW\*(C`\-f\*(C'\fR flag to edit the files directly.
.SS "Other special characters and reserved words"
.IX Subsection "Other special characters and reserved words"
The pound sign ('#') is used to indicate a comment (unless it is
part of a #include directive or unless it occurs in the context of
a user name and is followed by one or more digits, in which case
it is treated as a uid).  Both the comment character and any text
after it, up to the end of the line, are ignored.
.PP
The reserved word \fB\s-1ALL\s0\fR is a built-in \fIalias\fR that always causes
a match to succeed.  It can be used wherever one might otherwise
use a \f(CW\*(C`Cmnd_Alias\*(C'\fR, \f(CW\*(C`User_Alias\*(C'\fR, \f(CW\*(C`Runas_Alias\*(C'\fR, or \f(CW\*(C`Host_Alias\*(C'\fR.
You should not try to define your own \fIalias\fR called \fB\s-1ALL\s0\fR as the
built-in alias will be used in preference to your own.  Please note
that using \fB\s-1ALL\s0\fR can be dangerous since in a command context, it
allows the user to run \fBany\fR command on the system.
.PP
An exclamation point ('!') can be used as a logical \fInot\fR operator
both in an \fIalias\fR and in front of a \f(CW\*(C`Cmnd\*(C'\fR.  This allows one to
exclude certain values.  Note, however, that using a \f(CW\*(C`!\*(C'\fR in
conjunction with the built-in \f(CW\*(C`ALL\*(C'\fR alias to allow a user to
run \*(L"all but a few\*(R" commands rarely works as intended (see \s-1SECURITY\s0
\&\s-1NOTES\s0 below).
.PP
Long lines can be continued with a backslash ('\e') as the last
character on the line.
.PP
Whitespace between elements in a list as well as special syntactic
characters in a \fIUser Specification\fR ('=', ':', '(', ')') is optional.
.PP
The following characters must be escaped with a backslash ('\e') when
used as part of a word (e.g.\ a user name or host name):
\&'@', '!', '=', ':', ',', '(', ')', '\e'.
.SH "SUDOERS OPTIONS"
.IX Header "SUDOERS OPTIONS"
\&\fBsudo\fR's behavior can be modified by \f(CW\*(C`Default_Entry\*(C'\fR lines, as
explained earlier.  A list of all supported Defaults parameters,
grouped by type, are listed below.
.PP
\&\fBBoolean Flags\fR:
.IP "always_set_home" 16
.IX Item "always_set_home"
If enabled, \fBsudo\fR will set the \f(CW\*(C`HOME\*(C'\fR environment variable to the
home directory of the target user (which is root unless the \fB\-u\fR
option is used).  This effectively means that the \fB\-H\fR option is
always implied.  Note that \f(CW\*(C`HOME\*(C'\fR is already set when the the
\&\fIenv_reset\fR option is enabled, so \fIalways_set_home\fR is only
effective for configurations where \fIenv_reset\fR is disabled.
This flag is \fIoff\fR by default.
.IP "authenticate" 16
.IX Item "authenticate"
If set, users must authenticate themselves via a password (or other
means of authentication) before they may run commands.  This default
may be overridden via the \f(CW\*(C`PASSWD\*(C'\fR and \f(CW\*(C`NOPASSWD\*(C'\fR tags.
This flag is \fIon\fR by default.
.IP "closefrom_override" 16
.IX Item "closefrom_override"
If set, the user may use \fBsudo\fR's \fB\-C\fR option which
overrides the default starting point at which \fBsudo\fR begins
closing open file descriptors.  This flag is \fIoff\fR by default.
.IP "compress_io" 16
.IX Item "compress_io"
If set, and \fBsudo\fR is configured to log a command's input or output,
the I/O logs will be compressed using \fBzlib\fR.  This flag is \fIon\fR
by default when \fBsudo\fR is compiled with \fBzlib\fR support.
.IP "env_editor" 16
.IX Item "env_editor"
If set, \fBvisudo\fR will use the value of the \s-1EDITOR\s0 or \s-1VISUAL\s0
environment variables before falling back on the default editor list.
Note that this may create a security hole as it allows the user to
run any arbitrary command as root without logging.  A safer alternative
is to place a colon-separated list of editors in the \f(CW\*(C`editor\*(C'\fR
variable.  \fBvisudo\fR will then only use the \s-1EDITOR\s0 or \s-1VISUAL\s0 if
they match a value specified in \f(CW\*(C`editor\*(C'\fR.  This flag is \fIoff\fR by
default.
.IP "env_reset" 16
.IX Item "env_reset"
If set, \fBsudo\fR will reset the environment to only contain the
\&\s-1LOGNAME\s0, \s-1MAIL\s0, \s-1SHELL\s0, \s-1USER\s0, \s-1USERNAME\s0 and the \f(CW\*(C`SUDO_*\*(C'\fR variables.  Any
variables in the caller's environment that match the \f(CW\*(C`env_keep\*(C'\fR
and \f(CW\*(C`env_check\*(C'\fR lists are then added.  The default contents of the
\&\f(CW\*(C`env_keep\*(C'\fR and \f(CW\*(C`env_check\*(C'\fR lists are displayed when \fBsudo\fR is
run by root with the \fI\-V\fR option.  If the \fIsecure_path\fR option
is set, its value will be used for the \f(CW\*(C`PATH\*(C'\fR environment variable.
This flag is \fIon\fR by default.
.IP "fast_glob" 16
.IX Item "fast_glob"
Normally, \fBsudo\fR uses the \fIglob\fR\|(3) function to do shell-style
globbing when matching path names.  However, since it accesses the
file system, \fIglob\fR\|(3) can take a long time to complete for some
patterns, especially when the pattern references a network file
system that is mounted on demand (automounted).  The \fIfast_glob\fR
option causes \fBsudo\fR to use the \fIfnmatch\fR\|(3) function, which does
not access the file system to do its matching.  The disadvantage
of \fIfast_glob\fR is that it is unable to match relative path names
such as \fI./ls\fR or \fI../bin/ls\fR.  This has security implications
when path names that include globbing characters are used with the
negation operator, \f(CW\*(Aq!\*(Aq\fR, as such rules can be trivially bypassed.
As such, this option should not be used when \fIsudoers\fR contains rules 
that contain negated path names which include globbing characters.
This flag is \fIoff\fR by default.
.IP "fqdn" 16
.IX Item "fqdn"
Set this flag if you want to put fully qualified host names in the
\&\fIsudoers\fR file.  I.e., instead of myhost you would use myhost.mydomain.edu.
You may still use the short form if you wish (and even mix the two).
Beware that turning on \fIfqdn\fR requires \fBsudo\fR to make \s-1DNS\s0 lookups
which may make \fBsudo\fR unusable if \s-1DNS\s0 stops working (for example
if the machine is not plugged into the network).  Also note that
you must use the host's official name as \s-1DNS\s0 knows it.  That is,
you may not use a host alias (\f(CW\*(C`CNAME\*(C'\fR entry) due to performance
issues and the fact that there is no way to get all aliases from
\&\s-1DNS\s0.  If your machine's host name (as returned by the \f(CW\*(C`hostname\*(C'\fR
command) is already fully qualified you shouldn't need to set
\&\fIfqdn\fR.  This flag is \fIoff\fR by default.
.IP "ignore_dot" 16
.IX Item "ignore_dot"
If set, \fBsudo\fR will ignore '.' or '' (current dir) in the \f(CW\*(C`PATH\*(C'\fR
environment variable; the \f(CW\*(C`PATH\*(C'\fR itself is not modified.  This
flag is \fIoff\fR by default.
.IP "ignore_local_sudoers" 16
.IX Item "ignore_local_sudoers"
If set via \s-1LDAP\s0, parsing of \fI/etc/sudoers\fR will be skipped.
This is intended for Enterprises that wish to prevent the usage of local
sudoers files so that only \s-1LDAP\s0 is used.  This thwarts the efforts of
rogue operators who would attempt to add roles to \fI/etc/sudoers\fR.
When this option is present, \fI/etc/sudoers\fR does not even need to
exist. Since this option tells \fBsudo\fR how to behave when no specific \s-1LDAP\s0
entries have been matched, this sudoOption is only meaningful for the
\&\f(CW\*(C`cn=defaults\*(C'\fR section.  This flag is \fIoff\fR by default.
.IP "insults" 16
.IX Item "insults"
If set, \fBsudo\fR will insult users when they enter an incorrect
password.  This flag is \fIoff\fR by default.
.IP "log_host" 16
.IX Item "log_host"
If set, the host name will be logged in the (non-syslog) \fBsudo\fR log file.
This flag is \fIoff\fR by default.
.IP "log_year" 16
.IX Item "log_year"
If set, the four-digit year will be logged in the (non-syslog) \fBsudo\fR log file.
This flag is \fIoff\fR by default.
.IP "long_otp_prompt" 16
.IX Item "long_otp_prompt"
When validating with a One Time Password (\s-1OPT\s0) scheme such as
\&\fBS/Key\fR or \fB\s-1OPIE\s0\fR, a two-line prompt is used to make it easier
to cut and paste the challenge to a local window.  It's not as
pretty as the default but some people find it more convenient.  This
flag is \fIoff\fR by default.
.IP "mail_always" 16
.IX Item "mail_always"
Send mail to the \fImailto\fR user every time a users runs \fBsudo\fR.
This flag is \fIoff\fR by default.
.IP "mail_badpass" 16
.IX Item "mail_badpass"
Send mail to the \fImailto\fR user if the user running \fBsudo\fR does not
enter the correct password.  This flag is \fIoff\fR by default.
.IP "mail_no_host" 16
.IX Item "mail_no_host"
If set, mail will be sent to the \fImailto\fR user if the invoking
user exists in the \fIsudoers\fR file, but is not allowed to run
commands on the current host.  This flag is \fIoff\fR by default.
.IP "mail_no_perms" 16
.IX Item "mail_no_perms"
If set, mail will be sent to the \fImailto\fR user if the invoking
user is allowed to use \fBsudo\fR but the command they are trying is not
listed in their \fIsudoers\fR file entry or is explicitly denied.
This flag is \fIoff\fR by default.
.IP "mail_no_user" 16
.IX Item "mail_no_user"
If set, mail will be sent to the \fImailto\fR user if the invoking
user is not in the \fIsudoers\fR file.  This flag is \fIon\fR
by default.
.IP "noexec" 16
.IX Item "noexec"
If set, all commands run via \fBsudo\fR will behave as if the \f(CW\*(C`NOEXEC\*(C'\fR
tag has been set, unless overridden by a \f(CW\*(C`EXEC\*(C'\fR tag.  See the
description of \fI\s-1NOEXEC\s0 and \s-1EXEC\s0\fR below as well as the \*(L"\s-1PREVENTING\s0 \s-1SHELL\s0
\&\s-1ESCAPES\s0\*(R" section at the end of this manual.  This flag is \fIoff\fR by default.
.IP "path_info" 16
.IX Item "path_info"
Normally, \fBsudo\fR will tell the user when a command could not be
found in their \f(CW\*(C`PATH\*(C'\fR environment variable.  Some sites may wish
to disable this as it could be used to gather information on the
location of executables that the normal user does not have access
to.  The disadvantage is that if the executable is simply not in
the user's \f(CW\*(C`PATH\*(C'\fR, \fBsudo\fR will tell the user that they are not
allowed to run it, which can be confusing.  This flag is \fIon\fR
by default.
.IP "passprompt_override" 16
.IX Item "passprompt_override"
The password prompt specified by \fIpassprompt\fR will normally only
be used if the password prompt provided by systems such as \s-1PAM\s0 matches
the string \*(L"Password:\*(R".  If \fIpassprompt_override\fR is set, \fIpassprompt\fR
will always be used.  This flag is \fIoff\fR by default.
.IP "preserve_groups" 16
.IX Item "preserve_groups"
By default, \fBsudo\fR will initialize the group vector to the list of
groups the target user is in.  When \fIpreserve_groups\fR is set, the
user's existing group vector is left unaltered.  The real and
effective group IDs, however, are still set to match the target
user.  This flag is \fIoff\fR by default.
.IP "pwfeedback" 16
.IX Item "pwfeedback"
By default, \fBsudo\fR reads the password like most other Unix programs,
by turning off echo until the user hits the return (or enter) key.
Some users become confused by this as it appears to them that \fBsudo\fR
has hung at this point.  When \fIpwfeedback\fR is set, \fBsudo\fR will
provide visual feedback when the user presses a key.  Note that
this does have a security impact as an onlooker may be able to
determine the length of the password being entered.
This flag is \fIoff\fR by default.
.IP "requiretty" 16
.IX Item "requiretty"
If set, \fBsudo\fR will only run when the user is logged in to a real
tty.  When this flag is set, \fBsudo\fR can only be run from a login
session and not via other means such as \fIcron\fR\|(8) or cgi-bin scripts.
This flag is \fIoff\fR by default.
.IP "root_sudo" 16
.IX Item "root_sudo"
If set, root is allowed to run \fBsudo\fR too.  Disabling this prevents users
from \*(L"chaining\*(R" \fBsudo\fR commands to get a root shell by doing something
like \f(CW"sudo sudo /bin/sh"\fR.  Note, however, that turning off \fIroot_sudo\fR
will also prevent root from running \fBsudoedit\fR.
Disabling \fIroot_sudo\fR provides no real additional security; it
exists purely for historical reasons.
This flag is \fIon\fR by default.
.IP "rootpw" 16
.IX Item "rootpw"
If set, \fBsudo\fR will prompt for the root password instead of the password
of the invoking user.  This flag is \fIoff\fR by default.
.IP "runaspw" 16
.IX Item "runaspw"
If set, \fBsudo\fR will prompt for the password of the user defined by the
\&\fIrunas_default\fR option (defaults to \f(CW\*(C`root\*(C'\fR) instead of the
password of the invoking user.  This flag is \fIoff\fR by default.
.IP "set_home" 16
.IX Item "set_home"
If enabled and \fBsudo\fR is invoked with the \fB\-s\fR option the \f(CW\*(C`HOME\*(C'\fR
environment variable will be set to the home directory of the target
user (which is root unless the \fB\-u\fR option is used).  This effectively
makes the \fB\-s\fR option imply \fB\-H\fR.  Note that \f(CW\*(C`HOME\*(C'\fR is already
set when the the \fIenv_reset\fR option is enabled, so \fIset_home\fR is
only effective for configurations where \fIenv_reset\fR is disabled.
This flag is \fIoff\fR by default.
.IP "set_logname" 16
.IX Item "set_logname"
Normally, \fBsudo\fR will set the \f(CW\*(C`LOGNAME\*(C'\fR, \f(CW\*(C`USER\*(C'\fR and \f(CW\*(C`USERNAME\*(C'\fR
environment variables to the name of the target user (usually root
unless the \fB\-u\fR option is given).  However, since some programs
(including the \s-1RCS\s0 revision control system) use \f(CW\*(C`LOGNAME\*(C'\fR to
determine the real identity of the user, it may be desirable to
change this behavior.  This can be done by negating the set_logname
option.  Note that if the \fIenv_reset\fR option has not been disabled,
entries in the \fIenv_keep\fR list will override the value of
\&\fIset_logname\fR.  This flag is \fIon\fR by default.
.IP "setenv" 16
.IX Item "setenv"
Allow the user to disable the \fIenv_reset\fR option from the command
line.  Additionally, environment variables set via the command line
are not subject to the restrictions imposed by \fIenv_check\fR,
\&\fIenv_delete\fR, or \fIenv_keep\fR.  As such, only trusted users should
be allowed to set variables in this manner.  This flag is \fIoff\fR
by default.
.IP "shell_noargs" 16
.IX Item "shell_noargs"
If set and \fBsudo\fR is invoked with no arguments it acts as if the
\&\fB\-s\fR option had been given.  That is, it runs a shell as root (the
shell is determined by the \f(CW\*(C`SHELL\*(C'\fR environment variable if it is
set, falling back on the shell listed in the invoking user's
/etc/passwd entry if not).  This flag is \fIoff\fR by default.
.IP "stay_setuid" 16
.IX Item "stay_setuid"
Normally, when \fBsudo\fR executes a command the real and effective
UIDs are set to the target user (root by default).  This option
changes that behavior such that the real \s-1UID\s0 is left as the invoking
user's \s-1UID\s0.  In other words, this makes \fBsudo\fR act as a setuid
wrapper.  This can be useful on systems that disable some potentially
dangerous functionality when a program is run setuid.  This option
is only effective on systems with either the \fIsetreuid()\fR or \fIsetresuid()\fR
function.  This flag is \fIoff\fR by default.
.IP "targetpw" 16
.IX Item "targetpw"
If set, \fBsudo\fR will prompt for the password of the user specified
by the \fB\-u\fR option (defaults to \f(CW\*(C`root\*(C'\fR) instead of the password
of the invoking user.  In addition, the timestamp file name will
include the target user's name.  Note that this flag precludes the
use of a uid not listed in the passwd database as an argument to
the \fB\-u\fR option.  This flag is \fIoff\fR by default.
.IP "log_input" 16
.IX Item "log_input"
If set, \fBsudo\fR will run the command in a \fIpseudo tty\fR and log all
user input.
If the standard input is not connected to the user's tty, due to
I/O redirection or because the command is part of a pipeline, that
input is also captured and stored in a separate log file.
.Sp
Input is logged to the \fI/var/log/sudo\-io\fR directory using a unique
session \s-1ID\s0 that is included in the normal \fBsudo\fR log line, prefixed
with \fITSID=\fR.
.IP "log_output" 16
.IX Item "log_output"
If set, \fBsudo\fR will run the command in a \fIpseudo tty\fR and log all
output that is sent to the screen, similar to the \fIscript\fR\|(1) command.
If the standard output or standard error is not connected to the
user's tty, due to I/O redirection or because the command is part
of a pipeline, that output is also captured and stored in separate
log files.
.Sp
Output is logged to the
\&\fI/var/log/sudo\-io\fR directory using a unique session \s-1ID\s0 that is
included in the normal \fBsudo\fR log line, prefixed with \fITSID=\fR.
.Sp
Output logs may be viewed with the \fIsudoreplay\fR\|(8) utility, which
can also be used to list or search the available logs.
.IP "tty_tickets" 16
.IX Item "tty_tickets"
If set, users must authenticate on a per-tty basis.  With this flag
enabled, \fBsudo\fR will use a file named for the tty the user is
logged in on in the user's time stamp directory.  If disabled, the
time stamp of the directory is used instead.  This flag is
\&\fIon\fR by default.
.IP "umask_override" 16
.IX Item "umask_override"
If set, \fBsudo\fR will set the umask as specified by \fIsudoers\fR without
modification.  This makes it possible to specify a more permissive
umask in \fIsudoers\fR than the user's own umask and matches historical
behavior.  If \fIumask_override\fR is not set, \fBsudo\fR will set the
umask to be the union of the user's umask and what is specified in
\&\fIsudoers\fR.  This flag is \fIoff\fR by default.
.if \n(LC \{\
.IP "use_loginclass" 16
.IX Item "use_loginclass"
If set, \fBsudo\fR will apply the defaults specified for the target user's
login class if one exists.  Only available if \fBsudo\fR is configured with
the \-\-with\-logincap option.  This flag is \fIoff\fR by default.
\}
.IP "use_pty" 16
.IX Item "use_pty"
If set, \fBsudo\fR will run the command in a pseudo-pty even if no I/O
logging is being gone.  A malicious program run under \fBsudo\fR could
conceivably fork a background process that retains to the user's
terminal device after the main program has finished executing.  Use
of this option will make that impossible.
.IP "visiblepw" 16
.IX Item "visiblepw"
By default, \fBsudo\fR will refuse to run if the user must enter a
password but it is not possible to disable echo on the terminal.
If the \fIvisiblepw\fR flag is set, \fBsudo\fR will prompt for a password
even when it would be visible on the screen.  This makes it possible
to run things like \f(CW"rsh somehost sudo ls"\fR since \fIrsh\fR\|(1) does
not allocate a tty.  This flag is \fIoff\fR by default.
.PP
\&\fBIntegers\fR:
.IP "closefrom" 16
.IX Item "closefrom"
Before it executes a command, \fBsudo\fR will close all open file
descriptors other than standard input, standard output and standard
error (ie: file descriptors 0\-2).  The \fIclosefrom\fR option can be used
to specify a different file descriptor at which to start closing.
The default is \f(CW3\fR.
.IP "passwd_tries" 16
.IX Item "passwd_tries"
The number of tries a user gets to enter his/her password before
\&\fBsudo\fR logs the failure and exits.  The default is \f(CW\*(C`3\*(C'\fR.
.PP
\&\fBIntegers that can be used in a boolean context\fR:
.IP "loglinelen" 16
.IX Item "loglinelen"
Number of characters per line for the file log.  This value is used
to decide when to wrap lines for nicer log files.  This has no
effect on the syslog log file, only the file log.  The default is
\&\f(CW\*(C`80\*(C'\fR (use 0 or negate the option to disable word wrap).
.IP "passwd_timeout" 16
.IX Item "passwd_timeout"
Number of minutes before the \fBsudo\fR password prompt times out, or
\&\f(CW0\fR for no timeout.  The timeout may include a fractional component
if minute granularity is insufficient, for example \f(CW2.5\fR.  The
default is \f(CW\*(C`5\*(C'\fR.
.IP "timestamp_timeout" 16
.IX Item "timestamp_timeout"
Number of minutes that can elapse before \fBsudo\fR will ask for a
passwd again.  The timeout may include a fractional component if
minute granularity is insufficient, for example \f(CW2.5\fR.  The default
is \f(CW\*(C`5\*(C'\fR.  Set this to \f(CW0\fR to always prompt for a password.
If set to a value less than \f(CW0\fR the user's timestamp will never
expire.  This can be used to allow users to create or delete their
own timestamps via \f(CW\*(C`sudo \-v\*(C'\fR and \f(CW\*(C`sudo \-k\*(C'\fR respectively.
.IP "umask" 16
.IX Item "umask"
Umask to use when running the command.  Negate this option or set
it to 0777 to preserve the user's umask.  The actual umask that is
used will be the union of the user's umask and the value of the
\&\fIumask\fR option, which defaults to \f(CW\*(C`0022\*(C'\fR.  This guarantees
that \fBsudo\fR never lowers the umask when running a command.  Note
on systems that use \s-1PAM\s0, the default \s-1PAM\s0 configuration may specify
its own umask which will override the value set in \fIsudoers\fR.
.PP
\&\fBStrings\fR:
.IP "badpass_message" 16
.IX Item "badpass_message"
Message that is displayed if a user enters an incorrect password.
The default is \f(CW\*(C`Sorry, try again.\*(C'\fR unless insults are enabled.
.IP "editor" 16
.IX Item "editor"
A colon (':') separated list of editors allowed to be used with
\&\fBvisudo\fR.  \fBvisudo\fR will choose the editor that matches the user's
\&\s-1EDITOR\s0 environment variable if possible, or the first editor in the
list that exists and is executable.  The default is \f(CW"/usr/bin/vi"\fR.
.IP "mailsub" 16
.IX Item "mailsub"
Subject of the mail sent to the \fImailto\fR user. The escape \f(CW%h\fR
will expand to the host name of the machine.
Default is \f(CW\*(C`*** SECURITY information for %h ***\*(C'\fR.
.IP "noexec_file" 16
.IX Item "noexec_file"
Path to a shared library containing dummy versions of the \fIexecv()\fR,
\&\fIexecve()\fR and \fIfexecve()\fR library functions that just return an error.
This is used to implement the \fInoexec\fR functionality on systems that
support \f(CW\*(C`LD_PRELOAD\*(C'\fR or its equivalent.  Defaults to \fI/usr/local/libexec/sudo_noexec.so\fR.
.IP "passprompt" 16
.IX Item "passprompt"
The default prompt to use when asking for a password; can be overridden
via the \fB\-p\fR option or the \f(CW\*(C`SUDO_PROMPT\*(C'\fR environment variable.
The following percent (`\f(CW\*(C`%\*(C'\fR') escapes are supported:
.RS 16
.ie n .IP "%H" 4
.el .IP "\f(CW%H\fR" 4
.IX Item "%H"
expanded to the local host name including the domain name
(on if the machine's host name is fully qualified or the \fIfqdn\fR
option is set)
.ie n .IP "%h" 4
.el .IP "\f(CW%h\fR" 4
.IX Item "%h"
expanded to the local host name without the domain name
.ie n .IP "%p" 4
.el .IP "\f(CW%p\fR" 4
.IX Item "%p"
expanded to the user whose password is being asked for (respects the 
\&\fIrootpw\fR, \fItargetpw\fR and \fIrunaspw\fR flags in \fIsudoers\fR)
.ie n .IP "%U" 4
.el .IP "\f(CW%U\fR" 4
.IX Item "%U"
expanded to the login name of the user the command will
be run as (defaults to root)
.ie n .IP "%u" 4
.el .IP "\f(CW%u\fR" 4
.IX Item "%u"
expanded to the invoking user's login name
.ie n .IP "\*(C`%%\*(C'" 4
.el .IP "\f(CW\*(C`%%\*(C'\fR" 4
.IX Item "%%"
two consecutive \f(CW\*(C`%\*(C'\fR characters are collapsed into a single \f(CW\*(C`%\*(C'\fR character
.RE
.RS 16
.Sp
The default value is \f(CW\*(C`Password:\*(C'\fR.
.RE
.if \n(SL \{\
.IP "role" 16
.IX Item "role"
The default SELinux role to use when constructing a new security
context to run the command.  The default role may be overridden on
a per-command basis in \fIsudoers\fR or via command line options.
This option is only available whe \fBsudo\fR is built with SELinux support.
\}
.IP "runas_default" 16
.IX Item "runas_default"
The default user to run commands as if the \fB\-u\fR option is not specified
on the command line.  This defaults to \f(CW\*(C`root\*(C'\fR.
Note that if \fIrunas_default\fR is set it \fBmust\fR occur before
any \f(CW\*(C`Runas_Alias\*(C'\fR specifications.
.IP "syslog_badpri" 16
.IX Item "syslog_badpri"
Syslog priority to use when user authenticates unsuccessfully.
Defaults to \f(CW\*(C`alert\*(C'\fR.
.IP "syslog_goodpri" 16
.IX Item "syslog_goodpri"
Syslog priority to use when user authenticates successfully.
Defaults to \f(CW\*(C`notice\*(C'\fR.
.IP "sudoers_locale" 16
.IX Item "sudoers_locale"
Locale to use when parsing the sudoers file.  Note that changing
the locale may affect how sudoers is interpreted.
Defaults to \f(CW"C"\fR.
.IP "timestampdir" 16
.IX Item "timestampdir"
The directory in which \fBsudo\fR stores its timestamp files.
The default is \fI/var/db/sudo\fR.
.IP "timestampowner" 16
.IX Item "timestampowner"
The owner of the timestamp directory and the timestamps stored therein.
The default is \f(CW\*(C`root\*(C'\fR.
.if \n(SL \{\
.IP "type" 16
.IX Item "type"
The default SELinux type to use when constructing a new security
context to run the command.  The default type may be overridden on
a per-command basis in \fIsudoers\fR or via command line options.
This option is only available whe \fBsudo\fR is built with SELinux support.
\}
.PP
\&\fBStrings that can be used in a boolean context\fR:
.IP "askpass" 12
.IX Item "askpass"
The \fIaskpass\fR option specifies the fully qualified path to a helper
program used to read the user's password when no terminal is
available.  This may be the case when \fBsudo\fR is executed from a
graphical (as opposed to text-based) application.  The program
specified by \fIaskpass\fR should display the argument passed to it
as the prompt and write the user's password to the standard output.
The value of \fIaskpass\fR may be overridden by the \f(CW\*(C`SUDO_ASKPASS\*(C'\fR
environment variable.
.IP "env_file" 12
.IX Item "env_file"
The \fIenv_file\fR options specifies the fully qualified path to a
file containing variables to be set in the environment of the program
being run.  Entries in this file should either be of the form
\&\f(CW\*(C`VARIABLE=value\*(C'\fR or \f(CW\*(C`export VARIABLE=value\*(C'\fR.  The value may
optionally be surrounded by single or double quotes.  Variables in
this file are subject to other \fBsudo\fR environment settings such
as \fIenv_keep\fR and \fIenv_check\fR.
.IP "exempt_group" 12
.IX Item "exempt_group"
Users in this group are exempt from password and \s-1PATH\s0 requirements.
This is not set by default.
.IP "lecture" 12
.IX Item "lecture"
This option controls when a short lecture will be printed along with
the password prompt.  It has the following possible values:
.RS 12
.IP "always" 8
.IX Item "always"
Always lecture the user.
.IP "never" 8
.IX Item "never"
Never lecture the user.
.IP "once" 8
.IX Item "once"
Only lecture the user the first time they run \fBsudo\fR.
.RE
.RS 12
.Sp
If no value is specified, a value of \fIonce\fR is implied.
Negating the option results in a value of \fInever\fR being used.
The default value is \fIonce\fR.
.RE
.IP "lecture_file" 12
.IX Item "lecture_file"
Path to a file containing an alternate \fBsudo\fR lecture that will
be used in place of the standard lecture if the named file exists.
By default, \fBsudo\fR uses a built-in lecture.
.IP "listpw" 12
.IX Item "listpw"
This option controls when a password will be required when a
user runs \fBsudo\fR with the \fB\-l\fR option.  It has the following possible values:
.RS 12
.IP "all" 8
.IX Item "all"
All the user's \fIsudoers\fR entries for the current host must have
the \f(CW\*(C`NOPASSWD\*(C'\fR flag set to avoid entering a password.
.IP "always" 8
.IX Item "always"
The user must always enter a password to use the \fB\-l\fR option.
.IP "any" 8
.IX Item "any"
At least one of the user's \fIsudoers\fR entries for the current host
must have the \f(CW\*(C`NOPASSWD\*(C'\fR flag set to avoid entering a password.
.IP "never" 8
.IX Item "never"
The user need never enter a password to use the \fB\-l\fR option.
.RE
.RS 12
.Sp
If no value is specified, a value of \fIany\fR is implied.
Negating the option results in a value of \fInever\fR being used.
The default value is \fIany\fR.
.RE
.IP "logfile" 12
.IX Item "logfile"
Path to the \fBsudo\fR log file (not the syslog log file).  Setting a path
turns on logging to a file; negating this option turns it off.
By default, \fBsudo\fR logs via syslog.
.IP "mailerflags" 12
.IX Item "mailerflags"
Flags to use when invoking mailer. Defaults to \fB\-t\fR.
.IP "mailerpath" 12
.IX Item "mailerpath"
Path to mail program used to send warning mail.
Defaults to the path to sendmail found at configure time.
.IP "mailfrom" 12
.IX Item "mailfrom"
Address to use for the \*(L"from\*(R" address when sending warning and error
mail.  The address should be enclosed in double quotes (\f(CW\*(C`"\*(C'\fR) to
protect against \fBsudo\fR interpreting the \f(CW\*(C`@\*(C'\fR sign.  Defaults to
the name of the user running \fBsudo\fR.
.IP "mailto" 12
.IX Item "mailto"
Address to send warning and error mail to.  The address should
be enclosed in double quotes (\f(CW\*(C`"\*(C'\fR) to protect against \fBsudo\fR
interpreting the \f(CW\*(C`@\*(C'\fR sign.  Defaults to \f(CW\*(C`root\*(C'\fR.
.IP "secure_path" 12
.IX Item "secure_path"
Path used for every command run from \fBsudo\fR.  If you don't trust the
people running \fBsudo\fR to have a sane \f(CW\*(C`PATH\*(C'\fR environment variable you may
want to use this.  Another use is if you want to have the \*(L"root path\*(R"
be separate from the \*(L"user path.\*(R"  Users in the group specified by the
\&\fIexempt_group\fR option are not affected by \fIsecure_path\fR.
This option is not set by default.
.IP "syslog" 12
.IX Item "syslog"
Syslog facility if syslog is being used for logging (negate to
disable syslog logging).  Defaults to \f(CW\*(C`authpriv\*(C'\fR.
.IP "verifypw" 12
.IX Item "verifypw"
This option controls when a password will be required when a user runs
\&\fBsudo\fR with the \fB\-v\fR option.  It has the following possible values:
.RS 12
.IP "all" 8
.IX Item "all"
All the user's \fIsudoers\fR entries for the current host must have
the \f(CW\*(C`NOPASSWD\*(C'\fR flag set to avoid entering a password.
.IP "always" 8
.IX Item "always"
The user must always enter a password to use the \fB\-v\fR option.
.IP "any" 8
.IX Item "any"
At least one of the user's \fIsudoers\fR entries for the current host
must have the \f(CW\*(C`NOPASSWD\*(C'\fR flag set to avoid entering a password.
.IP "never" 8
.IX Item "never"
The user need never enter a password to use the \fB\-v\fR option.
.RE
.RS 12
.Sp
If no value is specified, a value of \fIall\fR is implied.
Negating the option results in a value of \fInever\fR being used.
The default value is \fIall\fR.
.RE
.PP
\&\fBLists that can be used in a boolean context\fR:
.IP "env_check" 16
.IX Item "env_check"
Environment variables to be removed from the user's environment if
the variable's value contains \f(CW\*(C`%\*(C'\fR or \f(CW\*(C`/\*(C'\fR characters.  This can
be used to guard against printf-style format vulnerabilities in
poorly-written programs.  The argument may be a double-quoted,
space-separated list or a single value without double-quotes.  The
list can be replaced, added to, deleted from, or disabled by using
the \f(CW\*(C`=\*(C'\fR, \f(CW\*(C`+=\*(C'\fR, \f(CW\*(C`\-=\*(C'\fR, and \f(CW\*(C`!\*(C'\fR operators respectively.  Regardless
of whether the \f(CW\*(C`env_reset\*(C'\fR option is enabled or disabled, variables
specified by \f(CW\*(C`env_check\*(C'\fR will be preserved in the environment if
they pass the aforementioned check.  The default list of environment
variables to check is displayed when \fBsudo\fR is run by root with
the \fI\-V\fR option.
.IP "env_delete" 16
.IX Item "env_delete"
Environment variables to be removed from the user's environment
when the \fIenv_reset\fR option is not in effect.  The argument may
be a double-quoted, space-separated list or a single value without
double-quotes.  The list can be replaced, added to, deleted from,
or disabled by using the \f(CW\*(C`=\*(C'\fR, \f(CW\*(C`+=\*(C'\fR, \f(CW\*(C`\-=\*(C'\fR, and \f(CW\*(C`!\*(C'\fR operators
respectively.  The default list of environment variables to remove
is displayed when \fBsudo\fR is run by root with the \fI\-V\fR option.
Note that many operating systems will remove potentially dangerous
variables from the environment of any setuid process (such as
\&\fBsudo\fR).
.IP "env_keep" 16
.IX Item "env_keep"
Environment variables to be preserved in the user's environment
when the \fIenv_reset\fR option is in effect.  This allows fine-grained
control over the environment \fBsudo\fR\-spawned processes will receive.
The argument may be a double-quoted, space-separated list or a
single value without double-quotes.  The list can be replaced, added
to, deleted from, or disabled by using the \f(CW\*(C`=\*(C'\fR, \f(CW\*(C`+=\*(C'\fR, \f(CW\*(C`\-=\*(C'\fR, and
\&\f(CW\*(C`!\*(C'\fR operators respectively.  The default list of variables to keep
is displayed when \fBsudo\fR is run by root with the \fI\-V\fR option.
.PP
When logging via \fIsyslog\fR\|(3), \fBsudo\fR accepts the following values
for the syslog facility (the value of the \fBsyslog\fR Parameter):
\&\fBauthpriv\fR (if your \s-1OS\s0 supports it), \fBauth\fR, \fBdaemon\fR, \fBuser\fR,
\&\fBlocal0\fR, \fBlocal1\fR, \fBlocal2\fR, \fBlocal3\fR, \fBlocal4\fR, \fBlocal5\fR,
\&\fBlocal6\fR, and \fBlocal7\fR.  The following syslog priorities are
supported: \fBalert\fR, \fBcrit\fR, \fBdebug\fR, \fBemerg\fR, \fBerr\fR, \fBinfo\fR,
\&\fBnotice\fR, and \fBwarning\fR.
.SH "FILES"
.IX Header "FILES"
.ie n .IP "\fI/etc/sudoers\fR" 24
.el .IP "\fI/etc/sudoers\fR" 24
.IX Item "/etc/sudoers"
List of who can run what
.IP "\fI/etc/group\fR" 24
.IX Item "/etc/group"
Local groups file
.IP "\fI/etc/netgroup\fR" 24
.IX Item "/etc/netgroup"
List of network groups
.IP "\fI/var/log/sudo\-io\fR" 24
.IX Item "/var/log/sudo-io"
I/O log files
.SH "EXAMPLES"
.IX Header "EXAMPLES"
Below are example \fIsudoers\fR entries.  Admittedly, some of
these are a bit contrived.  First, we allow a few environment
variables to pass and then define our \fIaliases\fR:
.PP
.Vb 4
\& # Run X applications through sudo; HOME is used to find the
\& # .Xauthority file.  Note that other programs use HOME to find
\& # configuration files and this may lead to privilege escalation!
\& Defaults env_keep += "DISPLAY HOME"
\&
\& # User alias specification
\& User_Alias     FULLTIMERS = millert, mikef, dowdy
\& User_Alias     PARTTIMERS = bostley, jwfox, crawl
\& User_Alias     WEBMASTERS = will, wendy, wim
\&
\& # Runas alias specification
\& Runas_Alias    OP = root, operator
\& Runas_Alias    DB = oracle, sybase
\& Runas_Alias    ADMINGRP = adm, oper
\&
\& # Host alias specification
\& Host_Alias     SPARC = bigtime, eclipse, moet, anchor :\e
\&                SGI = grolsch, dandelion, black :\e
\&                ALPHA = widget, thalamus, foobar :\e
\&                HPPA = boa, nag, python
\& Host_Alias     CUNETS = 128.138.0.0/255.255.0.0
\& Host_Alias     CSNETS = 128.138.243.0, 128.138.204.0/24, 128.138.242.0
\& Host_Alias     SERVERS = master, mail, www, ns
\& Host_Alias     CDROM = orion, perseus, hercules
\&
\& # Cmnd alias specification
\& Cmnd_Alias     DUMPS = /usr/bin/mt, /usr/sbin/dump, /usr/sbin/rdump,\e
\&                        /usr/sbin/restore, /usr/sbin/rrestore
\& Cmnd_Alias     KILL = /usr/bin/kill
\& Cmnd_Alias     PRINTING = /usr/sbin/lpc, /usr/bin/lprm
\& Cmnd_Alias     SHUTDOWN = /usr/sbin/shutdown
\& Cmnd_Alias     HALT = /usr/sbin/halt
\& Cmnd_Alias     REBOOT = /usr/sbin/reboot
\& Cmnd_Alias     SHELLS = /usr/bin/sh, /usr/bin/csh, /usr/bin/ksh, \e
\&                         /usr/local/bin/tcsh, /usr/bin/rsh, \e
\&                         /usr/local/bin/zsh
\& Cmnd_Alias     SU = /usr/bin/su
\& Cmnd_Alias     PAGERS = /usr/bin/more, /usr/bin/pg, /usr/bin/less
.Ve
.PP
Here we override some of the compiled in default values.  We want
\&\fBsudo\fR to log via \fIsyslog\fR\|(3) using the \fIauth\fR facility in all
cases.  We don't want to subject the full time staff to the \fBsudo\fR
lecture, user \fBmillert\fR need not give a password, and we don't
want to reset the \f(CW\*(C`LOGNAME\*(C'\fR, \f(CW\*(C`USER\*(C'\fR or \f(CW\*(C`USERNAME\*(C'\fR environment
variables when running commands as root.  Additionally, on the
machines in the \fI\s-1SERVERS\s0\fR \f(CW\*(C`Host_Alias\*(C'\fR, we keep an additional
local log file and make sure we log the year in each log line since
the log entries will be kept around for several years.  Lastly, we
disable shell escapes for the commands in the \s-1PAGERS\s0 \f(CW\*(C`Cmnd_Alias\*(C'\fR
(\fI/usr/bin/more\fR, \fI/usr/bin/pg\fR and \fI/usr/bin/less\fR).
.PP
.Vb 7
\& # Override built\-in defaults
\& Defaults               syslog=auth
\& Defaults>root          !set_logname
\& Defaults:FULLTIMERS    !lecture
\& Defaults:millert       !authenticate
\& Defaults@SERVERS       log_year, logfile=/var/log/sudo.log
\& Defaults!PAGERS        noexec
.Ve
.PP
The \fIUser specification\fR is the part that actually determines who may
run what.
.PP
.Vb 2
\& root           ALL = (ALL) ALL
\& %wheel         ALL = (ALL) ALL
.Ve
.PP
We let \fBroot\fR and any user in group \fBwheel\fR run any command on any
host as any user.
.PP
.Vb 1
\& FULLTIMERS     ALL = NOPASSWD: ALL
.Ve
.PP
Full time sysadmins (\fBmillert\fR, \fBmikef\fR, and \fBdowdy\fR) may run any
command on any host without authenticating themselves.
.PP
.Vb 1
\& PARTTIMERS     ALL = ALL
.Ve
.PP
Part time sysadmins (\fBbostley\fR, \fBjwfox\fR, and \fBcrawl\fR) may run any
command on any host but they must authenticate themselves first
(since the entry lacks the \f(CW\*(C`NOPASSWD\*(C'\fR tag).
.PP
.Vb 1
\& jack           CSNETS = ALL
.Ve
.PP
The user \fBjack\fR may run any command on the machines in the \fI\s-1CSNETS\s0\fR alias
(the networks \f(CW128.138.243.0\fR, \f(CW128.138.204.0\fR, and \f(CW128.138.242.0\fR).
Of those networks, only \f(CW128.138.204.0\fR has an explicit netmask (in
\&\s-1CIDR\s0 notation) indicating it is a class C network.  For the other
networks in \fI\s-1CSNETS\s0\fR, the local machine's netmask will be used
during matching.
.PP
.Vb 1
\& lisa           CUNETS = ALL
.Ve
.PP
The user \fBlisa\fR may run any command on any host in the \fI\s-1CUNETS\s0\fR alias
(the class B network \f(CW128.138.0.0\fR).
.PP
.Vb 2
\& operator       ALL = DUMPS, KILL, SHUTDOWN, HALT, REBOOT, PRINTING,\e
\&                sudoedit /etc/printcap, /usr/oper/bin/
.Ve
.PP
The \fBoperator\fR user may run commands limited to simple maintenance.
Here, those are commands related to backups, killing processes, the
printing system, shutting down the system, and any commands in the
directory \fI/usr/oper/bin/\fR.
.PP
.Vb 1
\& joe            ALL = /usr/bin/su operator
.Ve
.PP
The user \fBjoe\fR may only \fIsu\fR\|(1) to operator.
.PP
.Vb 1
\& pete           HPPA = /usr/bin/passwd [A\-Za\-z]*, !/usr/bin/passwd root
\&
\& %opers         ALL = (: ADMINGRP) /usr/sbin/
.Ve
.PP
Users in the \fBopers\fR group may run commands in \fI/usr/sbin/\fR as themselves
with any group in the \fI\s-1ADMINGRP\s0\fR \f(CW\*(C`Runas_Alias\*(C'\fR (the \fBadm\fR and \fBoper\fR
groups).
.PP
The user \fBpete\fR is allowed to change anyone's password except for
root on the \fI\s-1HPPA\s0\fR machines.  Note that this assumes \fIpasswd\fR\|(1)
does not take multiple user names on the command line.
.PP
.Vb 1
\& bob            SPARC = (OP) ALL : SGI = (OP) ALL
.Ve
.PP
The user \fBbob\fR may run anything on the \fI\s-1SPARC\s0\fR and \fI\s-1SGI\s0\fR machines
as any user listed in the \fI\s-1OP\s0\fR \f(CW\*(C`Runas_Alias\*(C'\fR (\fBroot\fR and \fBoperator\fR).
.PP
.Vb 1
\& jim            +biglab = ALL
.Ve
.PP
The user \fBjim\fR may run any command on machines in the \fIbiglab\fR netgroup.
\&\fBsudo\fR knows that \*(L"biglab\*(R" is a netgroup due to the '+' prefix.
.PP
.Vb 1
\& +secretaries   ALL = PRINTING, /usr/bin/adduser, /usr/bin/rmuser
.Ve
.PP
Users in the \fBsecretaries\fR netgroup need to help manage the printers
as well as add and remove users, so they are allowed to run those
commands on all machines.
.PP
.Vb 1
\& fred           ALL = (DB) NOPASSWD: ALL
.Ve
.PP
The user \fBfred\fR can run commands as any user in the \fI\s-1DB\s0\fR \f(CW\*(C`Runas_Alias\*(C'\fR
(\fBoracle\fR or \fBsybase\fR) without giving a password.
.PP
.Vb 1
\& john           ALPHA = /usr/bin/su [!\-]*, !/usr/bin/su *root*
.Ve
.PP
On the \fI\s-1ALPHA\s0\fR machines, user \fBjohn\fR may su to anyone except root
but he is not allowed to specify any options to the \fIsu\fR\|(1) command.
.PP
.Vb 1
\& jen            ALL, !SERVERS = ALL
.Ve
.PP
The user \fBjen\fR may run any command on any machine except for those
in the \fI\s-1SERVERS\s0\fR \f(CW\*(C`Host_Alias\*(C'\fR (master, mail, www and ns).
.PP
.Vb 1
\& jill           SERVERS = /usr/bin/, !SU, !SHELLS
.Ve
.PP
For any machine in the \fI\s-1SERVERS\s0\fR \f(CW\*(C`Host_Alias\*(C'\fR, \fBjill\fR may run
any commands in the directory \fI/usr/bin/\fR except for those commands
belonging to the \fI\s-1SU\s0\fR and \fI\s-1SHELLS\s0\fR \f(CW\*(C`Cmnd_Aliases\*(C'\fR.
.PP
.Vb 1
\& steve          CSNETS = (operator) /usr/local/op_commands/
.Ve
.PP
The user \fBsteve\fR may run any command in the directory /usr/local/op_commands/
but only as user operator.
.PP
.Vb 1
\& matt           valkyrie = KILL
.Ve
.PP
On his personal workstation, valkyrie, \fBmatt\fR needs to be able to
kill hung processes.
.PP
.Vb 1
\& WEBMASTERS     www = (www) ALL, (root) /usr/bin/su www
.Ve
.PP
On the host www, any user in the \fI\s-1WEBMASTERS\s0\fR \f(CW\*(C`User_Alias\*(C'\fR (will,
wendy, and wim), may run any command as user www (which owns the
web pages) or simply \fIsu\fR\|(1) to www.
.PP
.Vb 2
\& ALL            CDROM = NOPASSWD: /sbin/umount /CDROM,\e
\&                /sbin/mount \-o nosuid\e,nodev /dev/cd0a /CDROM
.Ve
.PP
Any user may mount or unmount a CD-ROM on the machines in the \s-1CDROM\s0
\&\f(CW\*(C`Host_Alias\*(C'\fR (orion, perseus, hercules) without entering a password.
This is a bit tedious for users to type, so it is a prime candidate
for encapsulating in a shell script.
.SH "SECURITY NOTES"
.IX Header "SECURITY NOTES"
It is generally not effective to \*(L"subtract\*(R" commands from \f(CW\*(C`ALL\*(C'\fR
using the '!' operator.  A user can trivially circumvent this
by copying the desired command to a different name and then
executing that.  For example:
.PP
.Vb 1
\&    bill        ALL = ALL, !SU, !SHELLS
.Ve
.PP
Doesn't really prevent \fBbill\fR from running the commands listed in
\&\fI\s-1SU\s0\fR or \fI\s-1SHELLS\s0\fR since he can simply copy those commands to a
different name, or use a shell escape from an editor or other
program.  Therefore, these kind of restrictions should be considered
advisory at best (and reinforced by policy).
.PP
Furthermore, if the \fIfast_glob\fR option is in use, it is not possible
to reliably negate commands where the path name includes globbing
(aka wildcard) characters.  This is because the C library's
\&\fIfnmatch\fR\|(3) function cannot resolve relative paths.  While this
is typically only an inconvenience for rules that grant privileges,
it can result in a security issue for rules that subtract or revoke
privileges.
.PP
For example, given the following \fIsudoers\fR entry:
.PP
.Vb 2
\& john   ALL = /usr/bin/passwd [a\-zA\-Z0\-9]*, /usr/bin/chsh [a\-zA\-Z0\-9]*,
\&      /usr/bin/chfn [a\-zA\-Z0\-9]*, !/usr/bin/* root
.Ve
.PP
User \fBjohn\fR can still run \f(CW\*(C`/usr/bin/passwd root\*(C'\fR if \fIfast_glob\fR is
enabled by changing to \fI/usr/bin\fR and running \f(CW\*(C`./passwd root\*(C'\fR instead.
.SH "PREVENTING SHELL ESCAPES"
.IX Header "PREVENTING SHELL ESCAPES"
Once \fBsudo\fR executes a program, that program is free to do whatever
it pleases, including run other programs.  This can be a security
issue since it is not uncommon for a program to allow shell escapes,
which lets a user bypass \fBsudo\fR's access control and logging.
Common programs that permit shell escapes include shells (obviously),
editors, paginators, mail and terminal programs.
.PP
There are two basic approaches to this problem:
.IP "restrict" 10
.IX Item "restrict"
Avoid giving users access to commands that allow the user to run
arbitrary commands.  Many editors have a restricted mode where shell
escapes are disabled, though \fBsudoedit\fR is a better solution to
running editors via \fBsudo\fR.  Due to the large number of programs that
offer shell escapes, restricting users to the set of programs that
do not is often unworkable.
.IP "noexec" 10
.IX Item "noexec"
Many systems that support shared libraries have the ability to
override default library functions by pointing an environment
variable (usually \f(CW\*(C`LD_PRELOAD\*(C'\fR) to an alternate shared library.
On such systems, \fBsudo\fR's \fInoexec\fR functionality can be used to
prevent a program run by \fBsudo\fR from executing any other programs.
Note, however, that this applies only to native dynamically-linked
executables.  Statically-linked executables and foreign executables
running under binary emulation are not affected.
.Sp
To tell whether or not \fBsudo\fR supports \fInoexec\fR, you can run
the following as root:
.Sp
.Vb 1
\&    sudo \-V | grep "dummy exec"
.Ve
.Sp
If the resulting output contains a line that begins with:
.Sp
.Vb 1
\&    File containing dummy exec functions:
.Ve
.Sp
then \fBsudo\fR may be able to replace the exec family of functions
in the standard library with its own that simply return an error.
Unfortunately, there is no foolproof way to know whether or not
\&\fInoexec\fR will work at compile-time.  \fInoexec\fR should work on
SunOS, Solaris, *BSD, Linux, \s-1IRIX\s0, Tru64 \s-1UNIX\s0, MacOS X, and HP-UX
11.x.  It is known \fBnot\fR to work on \s-1AIX\s0 and UnixWare.  \fInoexec\fR
is expected to work on most operating systems that support the
\&\f(CW\*(C`LD_PRELOAD\*(C'\fR environment variable.  Check your operating system's
manual pages for the dynamic linker (usually ld.so, ld.so.1, dyld,
dld.sl, rld, or loader) to see if \f(CW\*(C`LD_PRELOAD\*(C'\fR is supported.
.Sp
To enable \fInoexec\fR for a command, use the \f(CW\*(C`NOEXEC\*(C'\fR tag as documented
in the User Specification section above.  Here is that example again:
.Sp
.Vb 1
\& aaron  shanty = NOEXEC: /usr/bin/more, /usr/bin/vi
.Ve
.Sp
This allows user \fBaaron\fR to run \fI/usr/bin/more\fR and \fI/usr/bin/vi\fR
with \fInoexec\fR enabled.  This will prevent those two commands from
executing other commands (such as a shell).  If you are unsure
whether or not your system is capable of supporting \fInoexec\fR you
can always just try it out and see if it works.
.PP
Note that restricting shell escapes is not a panacea.  Programs
running as root are still capable of many potentially hazardous
operations (such as changing or overwriting files) that could lead
to unintended privilege escalation.  In the specific case of an
editor, a safer approach is to give the user permission to run
\&\fBsudoedit\fR.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fIrsh\fR\|(1), \fIsu\fR\|(1), \fIfnmatch\fR\|(3), \fIglob\fR\|(3), \fIsudo\fR\|(8), \fIvisudo\fR\|(8)
.SH "CAVEATS"
.IX Header "CAVEATS"
The \fIsudoers\fR file should \fBalways\fR be edited by the \fBvisudo\fR
command which locks the file and does grammatical checking. It is
imperative that \fIsudoers\fR be free of syntax errors since \fBsudo\fR
will not run with a syntactically incorrect \fIsudoers\fR file.
.PP
When using netgroups of machines (as opposed to users), if you
store fully qualified host name in the netgroup (as is usually the
case), you either need to have the machine's host name be fully qualified
as returned by the \f(CW\*(C`hostname\*(C'\fR command or use the \fIfqdn\fR option in
\&\fIsudoers\fR.
.SH "BUGS"
.IX Header "BUGS"
If you feel you have found a bug in \fBsudo\fR, please submit a bug report
at http://www.sudo.ws/sudo/bugs/
.SH "SUPPORT"
.IX Header "SUPPORT"
Limited free support is available via the sudo-users mailing list,
see http://www.sudo.ws/mailman/listinfo/sudo\-users to subscribe or
search the archives.
.SH "DISCLAIMER"
.IX Header "DISCLAIMER"
\&\fBsudo\fR is provided ``\s-1AS\s0 \s-1IS\s0'' and any express or implied warranties,
including, but not limited to, the implied warranties of merchantability
and fitness for a particular purpose are disclaimed.  See the \s-1LICENSE\s0
file distributed with \fBsudo\fR or http://www.sudo.ws/sudo/license.html
for complete details.
