.\" Copyright (c) 2003-2010
.\" 	Todd C. Miller <Todd.Miller@courtesan.com>
.\" 
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
.\" WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
.\" ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
.\" WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
.\" ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\" 
.\" Automatically generated by Pod::Man 2.22 (Pod::Simple 3.07)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` 
.    ds C' 
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.ie \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.el \{\
.    de IX
..
.\}
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "SUDOERS.LDAP 5"
.TH SUDOERS.LDAP 5 "July 12, 2010" "1.7.4" "MAINTENANCE COMMANDS"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH "NAME"
sudoers.ldap \- sudo LDAP configuration
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
In addition to the standard \fIsudoers\fR file, \fBsudo\fR may be configured
via \s-1LDAP\s0.  This can be especially useful for synchronizing \fIsudoers\fR
in a large, distributed environment.
.PP
Using \s-1LDAP\s0 for \fIsudoers\fR has several benefits:
.IP "\(bu" 4
\&\fBsudo\fR no longer needs to read \fIsudoers\fR in its entirety.  When
\&\s-1LDAP\s0 is used, there are only two or three \s-1LDAP\s0 queries per invocation.
This makes it especially fast and particularly usable in \s-1LDAP\s0
environments.
.IP "\(bu" 4
\&\fBsudo\fR no longer exits if there is a typo in \fIsudoers\fR.
It is not possible to load \s-1LDAP\s0 data into the server that does
not conform to the sudoers schema, so proper syntax is guaranteed.
It is still possible to have typos in a user or host name, but
this will not prevent \fBsudo\fR from running.
.IP "\(bu" 4
It is possible to specify per-entry options that override the global
default options.  \fI/etc/sudoers\fR only supports default options and
limited options associated with user/host/commands/aliases.  The
syntax is complicated and can be difficult for users to understand.
Placing the options directly in the entry is more natural.
.IP "\(bu" 4
The \fBvisudo\fR program is no longer needed.  \fBvisudo\fR provides
locking and syntax checking of the \fI/etc/sudoers\fR file.
Since \s-1LDAP\s0 updates are atomic, locking is no longer necessary.
Because syntax is checked when the data is inserted into \s-1LDAP\s0, there
is no need for a specialized tool to check syntax.
.PP
Another major difference between \s-1LDAP\s0 and file-based \fIsudoers\fR
is that in \s-1LDAP\s0, \fBsudo\fR\-specific Aliases are not supported.
.PP
For the most part, there is really no need for \fBsudo\fR\-specific
Aliases.  Unix groups or user netgroups can be used in place of
User_Aliases and RunasAliases.  Host netgroups can be used in place
of HostAliases.  Since Unix groups and netgroups can also be stored
in \s-1LDAP\s0 there is no real need for \fBsudo\fR\-specific aliases.
.PP
Cmnd_Aliases are not really required either since it is possible
to have multiple users listed in a sudoRole.  Instead of defining
a Cmnd_Alias that is referenced by multiple users, one can create
a sudoRole that contains the commands and assign multiple users
to it.
.SS "SUDOers \s-1LDAP\s0 container"
.IX Subsection "SUDOers LDAP container"
The \fIsudoers\fR configuration is contained in the \f(CW\*(C`ou=SUDOers\*(C'\fR \s-1LDAP\s0
container.
.PP
Sudo first looks for the \f(CW\*(C`cn=default\*(C'\fR entry in the SUDOers container.
If found, the multi-valued \f(CW\*(C`sudoOption\*(C'\fR attribute is parsed in the
same manner as a global \f(CW\*(C`Defaults\*(C'\fR line in \fI/etc/sudoers\fR.  In
the following example, the \f(CW\*(C`SSH_AUTH_SOCK\*(C'\fR variable will be preserved
in the environment for all users.
.PP
.Vb 6
\&    dn: cn=defaults,ou=SUDOers,dc=example,dc=com
\&    objectClass: top
\&    objectClass: sudoRole
\&    cn: defaults
\&    description: Default sudoOption\*(Aqs go here
\&    sudoOption: env_keep+=SSH_AUTH_SOCK
.Ve
.PP
The equivalent of a sudoer in \s-1LDAP\s0 is a \f(CW\*(C`sudoRole\*(C'\fR.  It consists of
the following components:
.IP "\fBsudoUser\fR" 4
.IX Item "sudoUser"
A user name, uid (prefixed with \f(CW\*(Aq#\*(Aq\fR), Unix group (prefixed with
a \f(CW\*(Aq%\*(Aq\fR) or user netgroup (prefixed with a \f(CW\*(Aq+\*(Aq\fR).
.IP "\fBsudoHost\fR" 4
.IX Item "sudoHost"
A host name, \s-1IP\s0 address, \s-1IP\s0 network, or host netgroup (prefixed
with a \f(CW\*(Aq+\*(Aq\fR).
The special value \f(CW\*(C`ALL\*(C'\fR will match any host.
.IP "\fBsudoCommand\fR" 4
.IX Item "sudoCommand"
A Unix command with optional command line arguments, potentially
including globbing characters (aka wild cards).
The special value \f(CW\*(C`ALL\*(C'\fR will match any command.
If a command is prefixed with an exclamation point \f(CW\*(Aq!\*(Aq\fR, the
user will be prohibited from running that command.
.IP "\fBsudoOption\fR" 4
.IX Item "sudoOption"
Identical in function to the global options described above, but
specific to the \f(CW\*(C`sudoRole\*(C'\fR in which it resides.
.IP "\fBsudoRunAsUser\fR" 4
.IX Item "sudoRunAsUser"
A user name or uid (prefixed with \f(CW\*(Aq#\*(Aq\fR) that commands may be run
as or a Unix group (prefixed with a \f(CW\*(Aq%\*(Aq\fR) or user netgroup (prefixed
with a \f(CW\*(Aq+\*(Aq\fR) that contains a list of users that commands may be
run as.
The special value \f(CW\*(C`ALL\*(C'\fR will match any user.
.IP "\fBsudoRunAsGroup\fR" 4
.IX Item "sudoRunAsGroup"
A Unix group or gid (prefixed with \f(CW\*(Aq#\*(Aq\fR) that commands may be run as.
The special value \f(CW\*(C`ALL\*(C'\fR will match any group.
.PP
Each component listed above should contain a single value, but there
may be multiple instances of each component type.  A sudoRole must
contain at least one \f(CW\*(C`sudoUser\*(C'\fR, \f(CW\*(C`sudoHost\*(C'\fR and \f(CW\*(C`sudoCommand\*(C'\fR.
.PP
The following example allows users in group wheel to run any command
on any host via \fBsudo\fR:
.PP
.Vb 7
\&    dn: cn=%wheel,ou=SUDOers,dc=example,dc=com
\&    objectClass: top
\&    objectClass: sudoRole
\&    cn: %wheel
\&    sudoUser: %wheel
\&    sudoHost: ALL
\&    sudoCommand: ALL
.Ve
.SS "Anatomy of \s-1LDAP\s0 sudoers lookup"
.IX Subsection "Anatomy of LDAP sudoers lookup"
When looking up a sudoer using \s-1LDAP\s0 there are only two or three
\&\s-1LDAP\s0 queries per invocation.  The first query is to parse the global
options.  The second is to match against the user's name and the
groups that the user belongs to.  (The special \s-1ALL\s0 tag is matched
in this query too.)  If no match is returned for the user's name
and groups, a third query returns all entries containing user
netgroups and checks to see if the user belongs to any of them.
.SS "Differences between \s-1LDAP\s0 and non-LDAP sudoers"
.IX Subsection "Differences between LDAP and non-LDAP sudoers"
There are some subtle differences in the way sudoers is handled
once in \s-1LDAP\s0.  Probably the biggest is that according to the \s-1RFC\s0,
\&\s-1LDAP\s0 ordering is arbitrary and you cannot expect that Attributes
and Entries are returned in any specific order.  If there are
conflicting command rules on an entry, the negative takes precedence.
This is called paranoid behavior (not necessarily the most specific
match).
.PP
Here is an example:
.PP
.Vb 5
\&    # /etc/sudoers:
\&    # Allow all commands except shell
\&    johnny  ALL=(root) ALL,!/bin/sh
\&    # Always allows all commands because ALL is matched last
\&    puddles ALL=(root) !/bin/sh,ALL
\&
\&    # LDAP equivalent of johnny
\&    # Allows all commands except shell
\&    dn: cn=role1,ou=Sudoers,dc=my\-domain,dc=com
\&    objectClass: sudoRole
\&    objectClass: top
\&    cn: role1
\&    sudoUser: johnny
\&    sudoHost: ALL
\&    sudoCommand: ALL
\&    sudoCommand: !/bin/sh
\&
\&    # LDAP equivalent of puddles
\&    # Notice that even though ALL comes last, it still behaves like
\&    # role1 since the LDAP code assumes the more paranoid configuration
\&    dn: cn=role2,ou=Sudoers,dc=my\-domain,dc=com
\&    objectClass: sudoRole
\&    objectClass: top
\&    cn: role2
\&    sudoUser: puddles
\&    sudoHost: ALL
\&    sudoCommand: !/bin/sh
\&    sudoCommand: ALL
.Ve
.PP
Another difference is that negations on the Host, User or Runas are
currently ignorred.  For example, the following attributes do not
behave the way one might expect.
.PP
.Vb 3
\&    # does not match all but joe
\&    # rather, does not match anyone
\&    sudoUser: !joe
\&
\&    # does not match all but joe
\&    # rather, matches everyone including Joe
\&    sudoUser: ALL
\&    sudoUser: !joe
\&
\&    # does not match all but web01
\&    # rather, matches all hosts including web01
\&    sudoHost: ALL
\&    sudoHost: !web01
.Ve
.SS "Sudoers Schema"
.IX Subsection "Sudoers Schema"
In order to use \fBsudo\fR's \s-1LDAP\s0 support, the \fBsudo\fR schema must be
installed on your \s-1LDAP\s0 server.  In addition, be sure to index the
\&'sudoUser' attribute.
.PP
Three versions of the schema: one for OpenLDAP servers (\fIschema.OpenLDAP\fR),
one for Netscape-derived servers (\fIschema.iPlanet\fR), and one for
Microsoft Active Directory (\fIschema.ActiveDirectory\fR) may
be found in the \fBsudo\fR distribution.
.PP
The schema for \fBsudo\fR in OpenLDAP form is included in the \s-1EXAMPLES\s0
section.
.SS "Configuring ldap.conf"
.IX Subsection "Configuring ldap.conf"
Sudo reads the \fI/etc/ldap.conf\fR file for LDAP-specific configuration.
Typically, this file is shared amongst different LDAP-aware clients.
As such, most of the settings are not \fBsudo\fR\-specific.  Note that
\&\fBsudo\fR parses \fI/etc/ldap.conf\fR itself and may support options
that differ from those described in the \fIldap.conf\fR\|(5) manual.
.PP
Also note that on systems using the OpenLDAP libraries, default
values specified in \fI/etc/openldap/ldap.conf\fR or the user's
\&\fI.ldaprc\fR files are not used.
.PP
Only those options explicitly listed in \fI/etc/ldap.conf\fR that are
supported by \fBsudo\fR are honored.  Configuration options are listed
below in upper case but are parsed in a case-independent manner.
.IP "\fB\s-1URI\s0\fR ldap[s]://[hostname[:port]] ..." 4
.IX Item "URI ldap[s]://[hostname[:port]] ..."
Specifies a whitespace-delimited list of one or more URIs describing
the \s-1LDAP\s0 server(s) to connect to.  The \fIprotocol\fR may be either
\&\fBldap\fR or \fBldaps\fR, the latter being for servers that support \s-1TLS\s0
(\s-1SSL\s0) encryption.  If no \fIport\fR is specified, the default is port
389 for \f(CW\*(C`ldap://\*(C'\fR or port 636 for \f(CW\*(C`ldaps://\*(C'\fR.  If no \fIhostname\fR
is specified, \fBsudo\fR will connect to \fBlocalhost\fR.  Multiple \fB\s-1URI\s0\fR
lines are treated identically to a \fB\s-1URI\s0\fR line containing multiple
entries.  Only systems using the OpenSSL libraries support the
mixing of \f(CW\*(C`ldap://\*(C'\fR and \f(CW\*(C`ldaps://\*(C'\fR URIs.  The Netscape-derived
libraries used on most commercial versions of Unix are only capable
of supporting one or the other.
.IP "\fB\s-1HOST\s0\fR name[:port] ..." 4
.IX Item "HOST name[:port] ..."
If no \fB\s-1URI\s0\fR is specified, the \fB\s-1HOST\s0\fR parameter specifies a
whitespace-delimited list of \s-1LDAP\s0 servers to connect to.  Each host
may include an optional \fIport\fR separated by a colon (':').  The
\&\fB\s-1HOST\s0\fR parameter is deprecated in favor of the \fB\s-1URI\s0\fR specification
and is included for backwards compatibility.
.IP "\fB\s-1PORT\s0\fR port_number" 4
.IX Item "PORT port_number"
If no \fB\s-1URI\s0\fR is specified, the \fB\s-1PORT\s0\fR parameter specifies the
default port to connect to on the \s-1LDAP\s0 server if a \fB\s-1HOST\s0\fR parameter
does not specify the port itself.  If no \fB\s-1PORT\s0\fR parameter is used,
the default is port 389 for \s-1LDAP\s0 and port 636 for \s-1LDAP\s0 over \s-1TLS\s0
(\s-1SSL\s0).  The \fB\s-1PORT\s0\fR parameter is deprecated in favor of the \fB\s-1URI\s0\fR
specification and is included for backwards compatibility.
.IP "\fB\s-1BIND_TIMELIMIT\s0\fR seconds" 4
.IX Item "BIND_TIMELIMIT seconds"
The \fB\s-1BIND_TIMELIMIT\s0\fR parameter specifies the amount of time, in seconds,
to wait while trying to connect to an \s-1LDAP\s0 server.  If multiple \fB\s-1URI\s0\fRs or
\&\fB\s-1HOST\s0\fRs are specified, this is the amount of time to wait before trying
the next one in the list.
.IP "\fB\s-1TIMELIMIT\s0\fR seconds" 4
.IX Item "TIMELIMIT seconds"
The \fB\s-1TIMELIMIT\s0\fR parameter specifies the amount of time, in seconds,
to wait for a response to an \s-1LDAP\s0 query.
.IP "\fB\s-1SUDOERS_BASE\s0\fR base" 4
.IX Item "SUDOERS_BASE base"
The base \s-1DN\s0 to use when performing \fBsudo\fR \s-1LDAP\s0 queries.  Typically
this is of the form \f(CW\*(C`ou=SUDOers,dc=example,dc=com\*(C'\fR for the domain
\&\f(CW\*(C`example.com\*(C'\fR.  Multiple \fB\s-1SUDOERS_BASE\s0\fR lines may be specified,
in which case they are queried in the order specified.
.IP "\fB\s-1SUDOERS_DEBUG\s0\fR debug_level" 4
.IX Item "SUDOERS_DEBUG debug_level"
This sets the debug level for \fBsudo\fR \s-1LDAP\s0 queries.  Debugging
information is printed to the standard error.  A value of 1 results
in a moderate amount of debugging information.  A value of 2 shows
the results of the matches themselves.  This parameter should not
be set in a production environment as the extra information is
likely to confuse users.
.IP "\fB\s-1BINDDN\s0\fR \s-1DN\s0" 4
.IX Item "BINDDN DN"
The \fB\s-1BINDDN\s0\fR parameter specifies the identity, in the form of a
Distinguished Name (\s-1DN\s0), to use when performing \s-1LDAP\s0 operations.
If not specified, \s-1LDAP\s0 operations are performed with an anonymous
identity.  By default, most \s-1LDAP\s0 servers will allow anonymous access.
.IP "\fB\s-1BINDPW\s0\fR secret" 4
.IX Item "BINDPW secret"
The \fB\s-1BINDPW\s0\fR parameter specifies the password to use when performing
\&\s-1LDAP\s0 operations.  This is typically used in conjunction with the
\&\fB\s-1BINDDN\s0\fR parameter.
.IP "\fB\s-1ROOTBINDDN\s0\fR \s-1DN\s0" 4
.IX Item "ROOTBINDDN DN"
The \fB\s-1ROOTBINDDN\s0\fR parameter specifies the identity, in the form of
a Distinguished Name (\s-1DN\s0), to use when performing privileged \s-1LDAP\s0
operations, such as \fIsudoers\fR queries.  The password corresponding
to the identity should be stored in \fI/etc/ldap.secret\fR.
If not specified, the \fB\s-1BINDDN\s0\fR identity is used (if any).
.IP "\fB\s-1LDAP_VERSION\s0\fR number" 4
.IX Item "LDAP_VERSION number"
The version of the \s-1LDAP\s0 protocol to use when connecting to the server.
The default value is protocol version 3.
.IP "\fB\s-1SSL\s0\fR on/true/yes/off/false/no" 4
.IX Item "SSL on/true/yes/off/false/no"
If the \fB\s-1SSL\s0\fR parameter is set to \f(CW\*(C`on\*(C'\fR, \f(CW\*(C`true\*(C'\fR or \f(CW\*(C`yes\*(C'\fR, \s-1TLS\s0
(\s-1SSL\s0) encryption is always used when communicating with the \s-1LDAP\s0
server.  Typically, this involves connecting to the server on port
636 (ldaps).
.IP "\fB\s-1SSL\s0\fR start_tls" 4
.IX Item "SSL start_tls"
If the \fB\s-1SSL\s0\fR parameter is set to \f(CW\*(C`start_tls\*(C'\fR, the \s-1LDAP\s0 server
connection is initiated normally and \s-1TLS\s0 encryption is begun before
the bind credentials are sent.  This has the advantage of not
requiring a dedicated port for encrypted communications.  This
parameter is only supported by \s-1LDAP\s0 servers that honor the \f(CW\*(C`start_tls\*(C'\fR
extension, such as the OpenLDAP server.
.IP "\fB\s-1TLS_CHECKPEER\s0\fR on/true/yes/off/false/no" 4
.IX Item "TLS_CHECKPEER on/true/yes/off/false/no"
If enabled, \fB\s-1TLS_CHECKPEER\s0\fR will cause the \s-1LDAP\s0 server's \s-1TLS\s0
certificated to be verified.  If the server's \s-1TLS\s0 certificate cannot
be verified (usually because it is signed by an unknown certificate
authority), \fBsudo\fR will be unable to connect to it.  If \fB\s-1TLS_CHECKPEER\s0\fR
is disabled, no check is made.  Note that disabling the check creates
an opportunity for man-in-the-middle attacks since the server's
identity will not be authenticated.  If possible, the \s-1CA\s0's certificate
should be installed locally so it can be verified.
.IP "\fB\s-1TLS_CACERT\s0\fR file name" 4
.IX Item "TLS_CACERT file name"
An alias for \fB\s-1TLS_CACERTFILE\s0\fR.
.IP "\fB\s-1TLS_CACERTFILE\s0\fR file name" 4
.IX Item "TLS_CACERTFILE file name"
The path to a certificate authority bundle which contains the certificates
for all the Certificate Authorities the client knows to be valid,
e.g. \fI/etc/ssl/ca\-bundle.pem\fR.
This option is only supported by the OpenLDAP libraries.
Netscape-derived \s-1LDAP\s0 libraries use the same certificate
database for \s-1CA\s0 and client certificates (see \fB\s-1TLS_CERT\s0\fR).
.IP "\fB\s-1TLS_CACERTDIR\s0\fR directory" 4
.IX Item "TLS_CACERTDIR directory"
Similar to \fB\s-1TLS_CACERTFILE\s0\fR but instead of a file, it is a
directory containing individual Certificate Authority certificates,
e.g. \fI/etc/ssl/certs\fR.
The directory specified by \fB\s-1TLS_CACERTDIR\s0\fR is checked after
\&\fB\s-1TLS_CACERTFILE\s0\fR.
This option is only supported by the OpenLDAP libraries.
.IP "\fB\s-1TLS_CERT\s0\fR file name" 4
.IX Item "TLS_CERT file name"
The path to a file containing the client certificate which can
be used to authenticate the client to the \s-1LDAP\s0 server.
The certificate type depends on the \s-1LDAP\s0 libraries used.
.Sp
OpenLDAP:
    \f(CW\*(C`tls_cert /etc/ssl/client_cert.pem\*(C'\fR
.Sp
Netscape-derived:
    \f(CW\*(C`tls_cert /var/ldap/cert7.db\*(C'\fR
.Sp
When using Netscape-derived libraries, this file may also contain
Certificate Authority certificates.
.IP "\fB\s-1TLS_KEY\s0\fR file name" 4
.IX Item "TLS_KEY file name"
The path to a file containing the private key which matches the
certificate specified by \fB\s-1TLS_CERT\s0\fR.  The private key must not be
password-protected.  The key type depends on the \s-1LDAP\s0 libraries
used.
.Sp
OpenLDAP:
    \f(CW\*(C`tls_key /etc/ssl/client_key.pem\*(C'\fR
.Sp
Netscape-derived:
    \f(CW\*(C`tls_key /var/ldap/key3.db\*(C'\fR
.IP "\fB\s-1TLS_RANDFILE\s0\fR file name" 4
.IX Item "TLS_RANDFILE file name"
The \fB\s-1TLS_RANDFILE\s0\fR parameter specifies the path to an entropy
source for systems that lack a random device.  It is generally used
in conjunction with \fIprngd\fR or \fIegd\fR.
This option is only supported by the OpenLDAP libraries.
.IP "\fB\s-1TLS_CIPHERS\s0\fR cipher list" 4
.IX Item "TLS_CIPHERS cipher list"
The \fB\s-1TLS_CIPHERS\s0\fR parameter allows the administer to restrict
which encryption algorithms may be used for \s-1TLS\s0 (\s-1SSL\s0) connections.
See the OpenSSL manual for a list of valid ciphers.
This option is only supported by the OpenLDAP libraries.
.IP "\fB\s-1USE_SASL\s0\fR on/true/yes/off/false/no" 4
.IX Item "USE_SASL on/true/yes/off/false/no"
Enable \fB\s-1USE_SASL\s0\fR for \s-1LDAP\s0 servers that support \s-1SASL\s0 authentication.
.IP "\fB\s-1SASL_AUTH_ID\s0\fR identity" 4
.IX Item "SASL_AUTH_ID identity"
The \s-1SASL\s0 user name to use when connecting to the \s-1LDAP\s0 server.
By default, \fBsudo\fR will use an anonymous connection.
.IP "\fB\s-1ROOTUSE_SASL\s0\fR on/true/yes/off/false/no" 4
.IX Item "ROOTUSE_SASL on/true/yes/off/false/no"
Enable \fB\s-1ROOTUSE_SASL\s0\fR to enable \s-1SASL\s0 authentication when connecting
to an \s-1LDAP\s0 server from a privileged process, such as \fBsudo\fR.
.IP "\fB\s-1ROOTSASL_AUTH_ID\s0\fR identity" 4
.IX Item "ROOTSASL_AUTH_ID identity"
The \s-1SASL\s0 user name to use when \fB\s-1ROOTUSE_SASL\s0\fR is enabled.
.IP "\fB\s-1SASL_SECPROPS\s0\fR none/properties" 4
.IX Item "SASL_SECPROPS none/properties"
\&\s-1SASL\s0 security properties or \fInone\fR for no properties.  See the
\&\s-1SASL\s0 programmer's manual for details.
.IP "\fB\s-1KRB5_CCNAME\s0\fR file name" 4
.IX Item "KRB5_CCNAME file name"
The path to the Kerberos 5 credential cache to use when authenticating
with the remote server.
.PP
See the \f(CW\*(C`ldap.conf\*(C'\fR entry in the \s-1EXAMPLES\s0 section.
.SS "Configuring nsswitch.conf"
.IX Subsection "Configuring nsswitch.conf"
Unless it is disabled at build time, \fBsudo\fR consults the Name
Service Switch file, \fI/etc/nsswitch.conf\fR, to specify the \fIsudoers\fR
search order.  Sudo looks for a line beginning with \f(CW\*(C`sudoers\*(C'\fR: and
uses this to determine the search order.  Note that \fBsudo\fR does
not stop searching after the first match and later matches take
precedence over earlier ones.
.PP
The following sources are recognized:
.PP
.Vb 2
\&    files       read sudoers from F</etc/sudoers>
\&    ldap        read sudoers from LDAP
.Ve
.PP
In addition, the entry \f(CW\*(C`[NOTFOUND=return]\*(C'\fR will short-circuit the
search if the user was not found in the preceding source.
.PP
To consult \s-1LDAP\s0 first followed by the local sudoers file (if it
exists), use:
.PP
.Vb 1
\&    sudoers: ldap files
.Ve
.PP
The local \fIsudoers\fR file can be ignored completely by using:
.PP
.Vb 1
\&    sudoers: ldap
.Ve
.PP
If the \fI/etc/nsswitch.conf\fR file is not present or there is no
sudoers line, the following default is assumed:
.PP
.Vb 1
\&    sudoers: files
.Ve
.PP
Note that \fI/etc/nsswitch.conf\fR is supported even when the underlying
operating system does not use an nsswitch.conf file.
.SS "Configuring netsvc.conf"
.IX Subsection "Configuring netsvc.conf"
On \s-1AIX\s0 systems, the \fI/etc/netsvc.conf\fR file is consulted instead of
\&\fI/etc/nsswitch.conf\fR.  \fBsudo\fR simply treats \fInetsvc.conf\fR as a
variant of \fInsswitch.conf\fR; information in the previous section
unrelated to the file format itself still applies.
.PP
To consult \s-1LDAP\s0 first followed by the local sudoers file (if it
exists), use:
.PP
.Vb 1
\&    sudoers = ldap, files
.Ve
.PP
The local \fIsudoers\fR file can be ignored completely by using:
.PP
.Vb 1
\&    sudoers = ldap
.Ve
.PP
To treat \s-1LDAP\s0 as authoratative and only use the local sudoers file
if the user is not present in \s-1LDAP\s0, use:
.PP
.Vb 1
\&    sudoers = ldap = auth, files
.Ve
.PP
Note that in the above example, the \f(CW\*(C`auth\*(C'\fR qualfier only affects
user lookups; both \s-1LDAP\s0 and \fIsudoers\fR will be queried for \f(CW\*(C`Defaults\*(C'\fR
entries.
.PP
If the \fI/etc/netsvc.conf\fR file is not present or there is no
sudoers line, the following default is assumed:
.PP
.Vb 1
\&    sudoers = files
.Ve
.SH "FILES"
.IX Header "FILES"
.ie n .IP "\fI/etc/ldap.conf\fR" 24
.el .IP "\fI/etc/ldap.conf\fR" 24
.IX Item "/etc/ldap.conf"
\&\s-1LDAP\s0 configuration file
.ie n .IP "\fI/etc/nsswitch.conf\fR" 24
.el .IP "\fI/etc/nsswitch.conf\fR" 24
.IX Item "/etc/nsswitch.conf"
determines sudoers source order
.ie n .IP "\fI/etc/netsvc.conf\fR" 24
.el .IP "\fI/etc/netsvc.conf\fR" 24
.IX Item "/etc/netsvc.conf"
determines sudoers source order on \s-1AIX\s0
.SH "EXAMPLES"
.IX Header "EXAMPLES"
.SS "Example ldap.conf"
.IX Subsection "Example ldap.conf"
.Vb 10
\&  # Either specify one or more URIs or one or more host:port pairs.
\&  # If neither is specified sudo will default to localhost, port 389.
\&  #
\&  #host          ldapserver
\&  #host          ldapserver1 ldapserver2:390
\&  #
\&  # Default port if host is specified without one, defaults to 389.
\&  #port          389
\&  #
\&  # URI will override the host and port settings.
\&  uri            ldap://ldapserver
\&  #uri            ldaps://secureldapserver
\&  #uri            ldaps://secureldapserver ldap://ldapserver
\&  #
\&  # The amount of time, in seconds, to wait while trying to connect to
\&  # an LDAP server.
\&  bind_timelimit 30
\&  #
\&  # The amount of time, in seconds, to wait while performing an LDAP query.
\&  timelimit 30
\&  #
\&  # Must be set or sudo will ignore LDAP; may be specified multiple times.
\&  sudoers_base   ou=SUDOers,dc=example,dc=com
\&  #
\&  # verbose sudoers matching from ldap
\&  #sudoers_debug 2
\&  #
\&  # optional proxy credentials
\&  #binddn        <who to search as>
\&  #bindpw        <password>
\&  #rootbinddn    <who to search as, uses /etc/ldap.secret for bindpw>
\&  #
\&  # LDAP protocol version, defaults to 3
\&  #ldap_version 3
\&  #
\&  # Define if you want to use an encrypted LDAP connection.
\&  # Typically, you must also set the port to 636 (ldaps).
\&  #ssl on
\&  #
\&  # Define if you want to use port 389 and switch to
\&  # encryption before the bind credentials are sent.
\&  # Only supported by LDAP servers that support the start_tls
\&  # extension such as OpenLDAP.
\&  #ssl start_tls
\&  #
\&  # Additional TLS options follow that allow tweaking of the
\&  # SSL/TLS connection.
\&  #
\&  #tls_checkpeer yes # verify server SSL certificate
\&  #tls_checkpeer no  # ignore server SSL certificate
\&  #
\&  # If you enable tls_checkpeer, specify either tls_cacertfile
\&  # or tls_cacertdir.  Only supported when using OpenLDAP.
\&  #
\&  #tls_cacertfile /etc/certs/trusted_signers.pem
\&  #tls_cacertdir  /etc/certs
\&  #
\&  # For systems that don\*(Aqt have /dev/random
\&  # use this along with PRNGD or EGD.pl to seed the
\&  # random number pool to generate cryptographic session keys.
\&  # Only supported when using OpenLDAP.
\&  #
\&  #tls_randfile /etc/egd\-pool
\&  #
\&  # You may restrict which ciphers are used.  Consult your SSL
\&  # documentation for which options go here.
\&  # Only supported when using OpenLDAP.
\&  #
\&  #tls_ciphers <cipher\-list>
\&  #
\&  # Sudo can provide a client certificate when communicating to
\&  # the LDAP server.
\&  # Tips:
\&  #   * Enable both lines at the same time.
\&  #   * Do not password protect the key file.
\&  #   * Ensure the keyfile is only readable by root.
\&  #
\&  # For OpenLDAP:
\&  #tls_cert /etc/certs/client_cert.pem
\&  #tls_key  /etc/certs/client_key.pem
\&  #
\&  # For SunONE or iPlanet LDAP, tls_cert and tls_key may specify either
\&  # a directory, in which case the files in the directory must have the
\&  # default names (e.g. cert8.db and key4.db), or the path to the cert
\&  # and key files themselves.  However, a bug in version 5.0 of the LDAP
\&  # SDK will prevent specific file names from working.  For this reason
\&  # it is suggested that tls_cert and tls_key be set to a directory,
\&  # not a file name.
\&  #
\&  # The certificate database specified by tls_cert may contain CA certs
\&  # and/or the client\*(Aqs cert.  If the client\*(Aqs cert is included, tls_key
\&  # should be specified as well.
\&  # For backward compatibility, "sslpath" may be used in place of tls_cert.
\&  #tls_cert /var/ldap
\&  #tls_key /var/ldap
\&  #
\&  # If using SASL authentication for LDAP (OpenSSL)
\&  # use_sasl yes
\&  # sasl_auth_id <SASL user name>
\&  # rootuse_sasl yes
\&  # rootsasl_auth_id <SASL user name for root access>
\&  # sasl_secprops none
\&  # krb5_ccname /etc/.ldapcache
.Ve
.SS "Sudo schema for OpenLDAP"
.IX Subsection "Sudo schema for OpenLDAP"
The following schema is in OpenLDAP format.  Simply copy it to the
schema directory (e.g. \fI/etc/openldap/schema\fR), add the proper
\&\f(CW\*(C`include\*(C'\fR line in \f(CW\*(C`slapd.conf\*(C'\fR and restart \fBslapd\fR.
.PP
.Vb 6
\& attributetype ( 1.3.6.1.4.1.15953.9.1.1
\&    NAME \*(AqsudoUser\*(Aq
\&    DESC \*(AqUser(s) who may  run sudo\*(Aq
\&    EQUALITY caseExactIA5Match
\&    SUBSTR caseExactIA5SubstringsMatch
\&    SYNTAX 1.3.6.1.4.1.1466.115.121.1.26 )
\&
\& attributetype ( 1.3.6.1.4.1.15953.9.1.2
\&    NAME \*(AqsudoHost\*(Aq
\&    DESC \*(AqHost(s) who may run sudo\*(Aq
\&    EQUALITY caseExactIA5Match
\&    SUBSTR caseExactIA5SubstringsMatch
\&    SYNTAX 1.3.6.1.4.1.1466.115.121.1.26 )
\&
\& attributetype ( 1.3.6.1.4.1.15953.9.1.3
\&    NAME \*(AqsudoCommand\*(Aq
\&    DESC \*(AqCommand(s) to be executed by sudo\*(Aq
\&    EQUALITY caseExactIA5Match
\&    SYNTAX 1.3.6.1.4.1.1466.115.121.1.26 )
\&
\& attributetype ( 1.3.6.1.4.1.15953.9.1.4
\&    NAME \*(AqsudoRunAs\*(Aq
\&    DESC \*(AqUser(s) impersonated by sudo\*(Aq
\&    EQUALITY caseExactIA5Match
\&    SYNTAX 1.3.6.1.4.1.1466.115.121.1.26 )
\&
\& attributetype ( 1.3.6.1.4.1.15953.9.1.5
\&    NAME \*(AqsudoOption\*(Aq
\&    DESC \*(AqOptions(s) followed by sudo\*(Aq
\&    EQUALITY caseExactIA5Match
\&    SYNTAX 1.3.6.1.4.1.1466.115.121.1.26 )
\&
\& attributetype ( 1.3.6.1.4.1.15953.9.1.6
\&    NAME \*(AqsudoRunAsUser\*(Aq
\&    DESC \*(AqUser(s) impersonated by sudo\*(Aq
\&    EQUALITY caseExactIA5Match
\&    SYNTAX 1.3.6.1.4.1.1466.115.121.1.26 )
\&
\& attributetype ( 1.3.6.1.4.1.15953.9.1.7
\&    NAME \*(AqsudoRunAsGroup\*(Aq
\&    DESC \*(AqGroup(s) impersonated by sudo\*(Aq
\&    EQUALITY caseExactIA5Match
\&    SYNTAX 1.3.6.1.4.1.1466.115.121.1.26 )
\&
\& objectclass ( 1.3.6.1.4.1.15953.9.2.1 NAME \*(AqsudoRole\*(Aq SUP top STRUCTURAL
\&    DESC \*(AqSudoer Entries\*(Aq
\&    MUST ( cn )
\&    MAY ( sudoUser $ sudoHost $ sudoCommand $ sudoRunAs $ sudoRunAsUser $
\&          sudoRunAsGroup $ sudoOption $ description )
\&    )
.Ve
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fIldap.conf\fR\|(5), \fIsudoers\fR\|(5)
.SH "CAVEATS"
.IX Header "CAVEATS"
The way that \fIsudoers\fR is parsed differs between Note that there
are differences in the way that LDAP-based \fIsudoers\fR is parsed
compared to file-based \fIsudoers\fR.  See the \*(L"Differences between
\&\s-1LDAP\s0 and non-LDAP sudoers\*(R" section for more information.
.SH "BUGS"
.IX Header "BUGS"
If you feel you have found a bug in \fBsudo\fR, please submit a bug report
at http://www.sudo.ws/sudo/bugs/
.SH "SUPPORT"
.IX Header "SUPPORT"
Limited free support is available via the sudo-users mailing list,
see http://www.sudo.ws/mailman/listinfo/sudo\-users to subscribe or
search the archives.
.SH "DISCLAIMER"
.IX Header "DISCLAIMER"
\&\fBsudo\fR is provided ``\s-1AS\s0 \s-1IS\s0'' and any express or implied warranties,
including, but not limited to, the implied warranties of merchantability
and fitness for a particular purpose are disclaimed.  See the \s-1LICENSE\s0
file distributed with \fBsudo\fR or http://www.sudo.ws/sudo/license.html
for complete details.
